/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mojang.serialization.MapCodec;
import com.mrbysco.enchantableblocks.block.EnchantedChestBlock;
import com.mrbysco.enchantableblocks.block.blockentity.EnchantedChestBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.EnchantedTrappedChestBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class EnchantedTrappedChestBlock
extends EnchantedChestBlock {
    public static final MapCodec<EnchantedChestBlock> CODEC = EnchantedTrappedChestBlock.simpleCodec(p_304364_ -> new EnchantedChestBlock((BlockBehaviour.Properties)p_304364_, ModRegistry.ENCHANTED_TRAPPED_CHEST_BLOCK_ENTITY::get));

    public EnchantedTrappedChestBlock(BlockBehaviour.Properties properties) {
        super(properties, ModRegistry.ENCHANTED_TRAPPED_CHEST_BLOCK_ENTITY::get);
    }

    @Override
    protected MapCodec<? extends AbstractChestBlock<EnchantedChestBlockEntity>> codec() {
        return CODEC;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedTrappedChestBlockEntity(pos, state);
    }

    @Override
    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    @Override
    public Item asItem() {
        return Items.TRAPPED_CHEST;
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return Mth.clamp((int)EnchantedChestBlockEntity.getOpenCount(blockAccess, pos), (int)0, (int)15);
    }

    public int getDirectSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP ? state.getSignal(blockAccess, pos, side) : 0;
    }

    @Override
    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        Holder<Enchantment> blastHolder;
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(blastHolder = EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION))) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(blastHolder);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE))) {
            return List.of();
        }
        return super.getDrops(state, params);
    }
}

