/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnchantedRespawnAnchorBlock
extends RespawnAnchorBlock
implements EntityBlock {
    public EnchantedRespawnAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedBlockEntity(pos, state);
    }

    public Item asItem() {
        return Items.RESPAWN_ANCHOR;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        ServerPlayer serverplayer;
        ItemStack itemstack = player.getItemInHand(hand);
        boolean explodes = false;
        int efficiency = 1;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockEntity;
            explodes = enchantable.hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockEntity, ModEnchantments.INTENTIONAL_GAME_DESIGN));
            Holder<Enchantment> efficiencyHolder = EnchantmentUtil.getEnchantmentHolder(blockEntity, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
            if (enchantable.hasEnchantment(efficiencyHolder)) {
                efficiency = enchantable.getEnchantmentLevel(efficiencyHolder);
            }
        }
        if (hand == InteractionHand.MAIN_HAND && !EnchantedRespawnAnchorBlock.isRespawnFuel(itemstack) && EnchantedRespawnAnchorBlock.isRespawnFuel(player.getItemInHand(InteractionHand.OFF_HAND))) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (EnchantedRespawnAnchorBlock.isRespawnFuel(itemstack) && EnchantedRespawnAnchorBlock.canBeCharged(state)) {
            EnchantedRespawnAnchorBlock.charge((Entity)player, level, pos, state, efficiency);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if ((Integer)state.getValue((Property)CHARGE) == 0) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!EnchantedRespawnAnchorBlock.canSetSpawn((Level)level) || explodes) {
            if (!level.isClientSide) {
                this.explode(state, level, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!(level.isClientSide || (serverplayer = (ServerPlayer)player).getRespawnDimension() == level.dimension() && pos.equals((Object)serverplayer.getRespawnPosition()))) {
            serverplayer.setRespawnPosition(level.dimension(), pos, 0.0f, false, true);
            level.playSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    public static void charge(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, int efficiency) {
        int currentCharge = (Integer)state.getValue((Property)CHARGE);
        int newCharge = Mth.clamp((int)(currentCharge + efficiency), (int)0, (int)4);
        BlockState blockstate = (BlockState)state.setValue((Property)CHARGE, (Comparable)Integer.valueOf(newCharge));
        level.setBlock(pos, blockstate, 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
        level.playSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static boolean isRespawnFuel(ItemStack stack) {
        return stack.is(Items.GLOWSTONE);
    }

    private static boolean canBeCharged(BlockState state) {
        return (Integer)state.getValue((Property)CHARGE) < 4;
    }

    private static boolean isWaterThatWouldFlow(BlockPos pos, Level level) {
        FluidState fluidstate = level.getFluidState(pos);
        if (!fluidstate.is(FluidTags.WATER)) {
            return false;
        }
        if (fluidstate.isSource()) {
            return true;
        }
        float f = fluidstate.getAmount();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluidstate1 = level.getFluidState(pos.below());
        return !fluidstate1.is(FluidTags.WATER);
    }

    private void explode(BlockState state, Level level, final BlockPos pos) {
        level.removeBlock(pos, false);
        boolean flag = Direction.Plane.HORIZONTAL.stream().map(arg_0 -> ((BlockPos)pos).relative(arg_0)).anyMatch(p_55854_ -> EnchantedRespawnAnchorBlock.isWaterThatWouldFlow(p_55854_, level));
        final boolean flag1 = flag || level.getFluidState(pos.above()).is(FluidTags.WATER);
        ExplosionDamageCalculator explosionDamageCalculator = new ExplosionDamageCalculator(this){

            public Optional<Float> getBlockExplosionResistance(Explosion p_55904_, BlockGetter p_55905_, BlockPos p_55906_, BlockState p_55907_, FluidState p_55908_) {
                return p_55906_.equals((Object)pos) && flag1 ? Optional.of(Float.valueOf(Blocks.WATER.getExplosionResistance())) : super.getBlockExplosionResistance(p_55904_, p_55905_, p_55906_, p_55907_, p_55908_);
            }
        };
        Vec3 vec3 = pos.getCenter();
        level.explode((Entity)null, level.damageSources().badRespawnPointExplosion(vec3), explosionDamageCalculator, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        Holder<Enchantment> blastHolder;
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(blastHolder = EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION))) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(blastHolder);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE))) {
            return List.of();
        }
        return super.getDrops(state, params);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource prandom) {
        IEnchantable enchantable;
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && !(enchantable = (IEnchantable)blockentity).hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockentity, ModEnchantments.CONCEALED))) {
            super.animateTick(state, level, pos, prandom);
        }
    }
}

