/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.util;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.impl.Book;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class ReloadCommand {
    private static final DynamicCommandExceptionType BOOK_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.literal((String)("Book with registry id " + String.valueOf(id) + " not found")));
    private static final SimpleCommandExceptionType NOT_CLIENT = new SimpleCommandExceptionType((Message)new LiteralMessage("This command can only be used in singleplayer"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"reload").then(Commands.argument((String)"bookid", (ArgumentType)ResourceLocationArgument.id()).executes(context -> {
            if (FMLEnvironment.dist != Dist.CLIENT) {
                throw NOT_CLIENT.create();
            }
            ResourceLocation id = ResourceLocationArgument.getId((CommandContext)context, (String)"bookid");
            Book b = GuideAPI.getBooks().get(id);
            if (b == null) {
                throw BOOK_NOT_FOUND.create((Object)id.toString());
            }
            b.forceInitializeContent();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Reloaded!"), true);
            return 0;
        }));
    }
}

