/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.proxy;

import de.maxanier.guideapi.api.BookEvent;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.CategoryScreen;
import de.maxanier.guideapi.gui.EntryScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import de.maxanier.guideapi.item.ItemGuideBookDataComponents;
import de.maxanier.guideapi.proxy.CommonProxy;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ClientProxy
extends CommonProxy {
    @Override
    public void initColors() {
        for (Supplier<ItemStack> bookStack : GuideAPI.getBookToStack().values()) {
            Minecraft.getInstance().getItemColors().register((stack, tintIndex) -> {
                IGuideItem guideItem = (IGuideItem)stack.getItem();
                if (guideItem.getBook(stack) != null && tintIndex == 0) {
                    return guideItem.getBook(stack).getColor().getRGB();
                }
                return -1;
            }, new ItemLike[]{bookStack.get().getItem()});
        }
    }

    @Override
    public void openEntry(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, Player player, ItemStack stack) {
        BookEvent.Open event = new BookEvent.Open(book, stack, player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            player.displayClientMessage(event.getCanceledText(), true);
            return;
        }
        Minecraft.getInstance().setScreen((Screen)new EntryScreen(book, categoryAbstract, entryAbstract, player, stack));
    }

    @Override
    public void openGuidebook(Player player, Level world, Book book, ItemStack bookStack) {
        if (!bookStack.isEmpty() && bookStack.getItem() instanceof IGuideItem) {
            book.initializeContent();
            try {
                if (bookStack.has(ItemGuideBookDataComponents.ENTRY) && bookStack.has(ItemGuideBookDataComponents.CATEGORY)) {
                    CategoryAbstract category = book.getCategoryList().get((Integer)bookStack.get(ItemGuideBookDataComponents.CATEGORY));
                    EntryAbstract entry = category.entries.get(bookStack.get(ItemGuideBookDataComponents.ENTRY));
                    int pageNumber = (Integer)bookStack.getOrDefault(ItemGuideBookDataComponents.PAGE, (Object)0);
                    EntryScreen guiEntry = new EntryScreen(book, category, entry, player, bookStack);
                    guiEntry.pageNumber = pageNumber;
                    Minecraft.getInstance().setScreen((Screen)guiEntry);
                    return;
                }
                if (bookStack.has(ItemGuideBookDataComponents.CATEGORY)) {
                    CategoryAbstract category = book.getCategoryList().get((Integer)bookStack.get(ItemGuideBookDataComponents.CATEGORY));
                    int entryPage = (Integer)bookStack.getOrDefault(ItemGuideBookDataComponents.PAGE, (Object)0);
                    CategoryScreen guiCategory = new CategoryScreen(book, category, player, bookStack, null);
                    guiCategory.entryPage = entryPage;
                    Minecraft.getInstance().setScreen((Screen)guiCategory);
                    return;
                }
                int categoryNumber = (Integer)bookStack.getOrDefault(ItemGuideBookDataComponents.PAGE, (Object)0);
                HomeScreen guiHome = new HomeScreen(book, player, bookStack);
                guiHome.categoryPage = categoryNumber;
                Minecraft.getInstance().setScreen((Screen)guiHome);
                return;
            }
            catch (Exception exception) {
                Minecraft.getInstance().setScreen((Screen)new HomeScreen(book, player, bookStack));
            }
        }
    }

    @Override
    public void playSound(SoundEvent sound) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f));
    }

    @Override
    public Optional<PotionBrewing> getPotionBrewing() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return Optional.of(level.potionBrewing());
        }
        return Optional.empty();
    }
}

