/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.network;

import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.item.ItemGuideBookDataComponents;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ReadingStatePayload(int page, Optional<Integer> category, Optional<ResourceLocation> entry) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReadingStatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"guideapi_vp", (String)"reading_state"));
    public static final StreamCodec<ByteBuf, ReadingStatePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ReadingStatePayload::page, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs::optional), ReadingStatePayload::category, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs::optional), ReadingStatePayload::entry, ReadingStatePayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ReadingStatePayload msg, IPayloadContext context) {
        Player player = context.player();
        Objects.requireNonNull(player);
        ItemStack book = player.getOffhandItem();
        if (book.isEmpty() || !(book.getItem() instanceof IGuideItem)) {
            book = player.getMainHandItem();
        }
        if (!book.isEmpty() && book.getItem() instanceof IGuideItem) {
            ItemStack finalBook = book;
            finalBook.set(ItemGuideBookDataComponents.PAGE, (Object)msg.page);
            msg.category.ifPresentOrElse(c -> finalBook.set(ItemGuideBookDataComponents.CATEGORY, c), () -> finalBook.remove(ItemGuideBookDataComponents.CATEGORY));
            msg.entry.ifPresentOrElse(e -> finalBook.set(ItemGuideBookDataComponents.ENTRY, e), () -> finalBook.remove(ItemGuideBookDataComponents.ENTRY));
        }
    }
}

