/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.item;

import de.maxanier.guideapi.GuideMod;
import de.maxanier.guideapi.api.BookEvent;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.IGuideLinked;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ItemGuideBook
extends Item
implements IGuideItem {
    @Nonnull
    private final Book book;
    private String translation_key;

    public ItemGuideBook(Book book) {
        super(new Item.Properties().stacksTo(1));
        this.book = book;
        this.setTranslation_key("guideapi_vp.book." + book.getRegistryName().getNamespace() + "." + book.getRegistryName().getPath());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext p_339594_, List<Component> tooltip, TooltipFlag advanced) {
        if (this.book.getAuthor() != null) {
            tooltip.add(this.book.getAuthor());
            if (advanced == TooltipFlag.Default.ADVANCED) {
                tooltip.add((Component)Component.literal((String)this.book.getRegistryName().toString()));
            }
        }
    }

    @Override
    public Book getBook(ItemStack stack) {
        return this.book;
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        return this.book.getRegistryName().getNamespace();
    }

    @Nonnull
    public Component getName(ItemStack stack) {
        return this.getBook(stack).getItemName() != null ? this.getBook(stack).getItemName() : super.getName(stack);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (!world.isClientSide()) {
            return InteractionResultHolder.success((Object)heldStack);
        }
        BookEvent.Open event = new BookEvent.Open(this.book, heldStack, player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            player.displayClientMessage(event.getCanceledText(), true);
            return InteractionResultHolder.fail((Object)heldStack);
        }
        GuideMod.PROXY.openGuidebook(player, world, this.book, heldStack);
        return InteractionResultHolder.success((Object)heldStack);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide || !context.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof IGuideLinked) {
            IGuideLinked guideLinked = (IGuideLinked)block;
            ResourceLocation entryKey = guideLinked.getLinkedEntry(context.getLevel(), context.getClickedPos(), context.getPlayer(), stack);
            if (entryKey == null) {
                return InteractionResult.FAIL;
            }
            for (CategoryAbstract category : this.book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                GuideMod.PROXY.openEntry(this.book, category, category.entries.get(entryKey), context.getPlayer(), stack);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    protected String getOrCreateDescriptionId() {
        if (this.translation_key == null) {
            this.translation_key = Util.makeDescriptionId((String)"item", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this));
        }
        return this.translation_key;
    }

    protected void setTranslation_key(String name) {
        this.translation_key = Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"guideapi_vp", (String)name));
    }
}

