/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import de.maxanier.guideapi.GuideMod;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.gui.BaseScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.glfw.GLFW;

public class SearchScreen
extends BaseScreen {
    private final Book book;
    private final ResourceLocation outlineTexture;
    private final ResourceLocation pageTexture;
    private final int renderXOffset = 37;
    private final int renderYOffset = 30;
    private final Screen parent;
    private ButtonNext buttonNext;
    private ButtonPrev buttonPrev;
    private EditBox searchField;
    private List<List<Pair<EntryAbstract, CategoryAbstract>>> searchResults;
    private int currentPage = 0;
    private String lastQuery = "";

    @Nonnull
    static List<List<Pair<EntryAbstract, CategoryAbstract>>> getMatches(Book book, @Nullable String query, Player player, ItemStack bookStack) {
        ArrayList discovered = Lists.newArrayList();
        for (CategoryAbstract category : book.getCategoryList()) {
            if (!category.canSee(player, bookStack)) continue;
            for (EntryAbstract entry : category.entries.values()) {
                if (!entry.canSee(player, bookStack) || !Strings.isNullOrEmpty((String)query) && !entry.getName().getString().toLowerCase(Locale.ENGLISH).contains(query.toLowerCase(Locale.ENGLISH))) continue;
                discovered.add(Pair.of((Object)entry, (Object)category));
            }
        }
        return Lists.partition((List)discovered, (int)10);
    }

    public SearchScreen(Book book, Player player, ItemStack bookStack, Screen parent) {
        super(book.getTitle(), player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.parent = parent;
        this.searchResults = SearchScreen.getMatches(book, null, player, bookStack);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            this.updateSearch();
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public void init() {
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.addRenderableWidget((GuiEventListener)new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.minecraft.setScreen(this.parent), this));
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.currentPage <= this.searchResults.size() - 1) {
                ++this.currentPage;
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonPrev);
        this.searchField = new EditBox(this.font, this.guiLeft + 43, this.guiTop + 12, 100, 10, (Component)Component.translatable((String)"guideapi.button.search"));
        this.searchField.setBordered(false);
        this.searchField.setFocused(true);
        this.searchResults = SearchScreen.getMatches(this.book, null, this.player, this.bookStack);
    }

    @Override
    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.searchField.isFocused()) {
            return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        }
        if (keyCode == 256) {
            this.searchField.setFocused(false);
        }
        if (this.searchField.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_)) {
            this.updateSearch();
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int typeofClick) {
        if (!super.mouseClicked(mouseX, mouseY, typeofClick)) {
            if (typeofClick == 0) {
                int entryX = this.guiLeft + 37;
                int entryY = this.guiTop + 30;
                if (this.searchResults.size() != 0 && this.currentPage >= 0 && this.currentPage < this.searchResults.size()) {
                    List<Pair<EntryAbstract, CategoryAbstract>> pageResults = this.searchResults.get(this.currentPage);
                    for (Pair<EntryAbstract, CategoryAbstract> entry : pageResults) {
                        if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, 4 * this.xSize / 6, 10)) {
                            GuideMod.PROXY.openEntry(this.book, (CategoryAbstract)entry.getRight(), (EntryAbstract)entry.getLeft(), this.player, this.bookStack);
                        }
                        entryY += 13;
                    }
                }
            } else if (typeofClick == 1) {
                if (GuiHelper.isMouseBetween(mouseX, mouseY, this.searchField.getX(), this.searchField.getY(), this.searchField.getInnerWidth(), this.searchField.getHeight())) {
                    this.searchField.setValue("");
                    this.lastQuery = "";
                    this.searchResults = SearchScreen.getMatches(this.book, "", this.player, this.bookStack);
                    return true;
                }
                this.minecraft.setScreen(this.parent);
                return true;
            }
            return this.searchField.mouseClicked(mouseX, mouseY, typeofClick);
        }
        return true;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY < 0.0 && this.buttonNext.visible && this.currentPage <= this.searchResults.size()) {
            ++this.currentPage;
        } else if (pScrollY > 0.0 && this.buttonPrev.visible && this.currentPage > 0) {
            --this.currentPage;
        }
        return pScrollY != 0.0 || super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.blit(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.fill(this.searchField.getX() - 1, this.searchField.getY() - 1, this.searchField.getX() + this.searchField.getInnerWidth() + 1, this.searchField.getY() + this.searchField.getHeight() + 1, new Color(166, 166, 166, 128).getRGB());
        graphics.fill(this.searchField.getX(), this.searchField.getY(), this.searchField.getX() + this.searchField.getInnerWidth(), this.searchField.getY() + this.searchField.getHeight(), new Color(58, 58, 58, 128).getRGB());
        this.searchField.render(graphics, mouseX, mouseY, partialTicks);
        int entryX = this.guiLeft + 37;
        int entryY = this.guiTop + 30;
        if (this.searchResults.size() != 0 && this.currentPage >= 0 && this.currentPage < this.searchResults.size()) {
            List<Pair<EntryAbstract, CategoryAbstract>> pageResults = this.searchResults.get(this.currentPage);
            for (Pair<EntryAbstract, CategoryAbstract> entry : pageResults) {
                ((EntryAbstract)entry.getLeft()).draw(graphics, Minecraft.getInstance().level.registryAccess(), this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.font);
                ((EntryAbstract)entry.getLeft()).drawExtras(graphics, this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.font);
                if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, 4 * this.xSize / 6, 10) && GLFW.glfwGetKey((long)this.minecraft.getWindow().getWindow(), (int)340) == 1) {
                    graphics.renderTooltip(this.font, ((CategoryAbstract)entry.getRight()).getTooltip(), Optional.empty(), mouseX, mouseY);
                }
                entryY += 13;
            }
        }
        this.buttonPrev.visible = this.currentPage != 0;
        this.buttonNext.visible = this.currentPage != this.searchResults.size() - 1 && !this.searchResults.isEmpty();
    }

    private void updateSearch() {
        if (!this.searchField.getValue().equalsIgnoreCase(this.lastQuery)) {
            this.lastQuery = this.searchField.getValue();
            this.searchResults = SearchScreen.getMatches(this.book, this.searchField.getValue(), this.player, this.bookStack);
            if (this.currentPage > this.searchResults.size()) {
                this.currentPage = this.searchResults.size() - 1;
            }
        }
    }
}

