/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.entry;

import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Entry;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntryItemStack
extends Entry {
    public ItemStack itemStack;

    public EntryItemStack(List<IPage> pageList, Component name, ItemStack stack) {
        super(pageList, name);
        this.itemStack = stack;
    }

    public EntryItemStack(Component name, ItemStack stack) {
        super(name);
        this.itemStack = stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(GuiGraphics graphics, Book book, CategoryAbstract category, int entryX, int entryY, int entryWidth, int entryHeight, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        if (this.itemStack != null) {
            GuiHelper.drawScaledItemStack(graphics, this.itemStack, entryX + 2, entryY, 0.5f);
        }
        super.drawExtras(graphics, book, category, entryX, entryY, entryWidth, entryHeight, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntryItemStack)) {
            return false;
        }
        EntryItemStack that = (EntryItemStack)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.itemStack, that.itemStack);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.itemStack != null ? this.itemStack.hashCode() : 0);
        return result;
    }
}

