/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.util;

import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageItemStack;
import de.maxanier.guideapi.page.PageText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class PageHelper {
    public static List<FormattedText> prepareForLongText(FormattedText text, int lineWidth, int firstHeight, int subsequentHeight) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        int firstCount = firstHeight / 9;
        Objects.requireNonNull(fontRenderer);
        int count = subsequentHeight / 9;
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>(fontRenderer.getSplitter().splitLines(text, lineWidth, Style.EMPTY));
        ArrayList<FormattedText> pages = new ArrayList<FormattedText>();
        ArrayList<FormattedText> pageLines = lines.size() > firstCount ? lines.subList(0, firstCount) : lines;
        pages.add(PageHelper.combineWithNewLine(pageLines));
        pageLines.clear();
        while (lines.size() > 0) {
            pageLines = lines.size() > count ? lines.subList(0, count) : lines;
            pages.add(PageHelper.combineWithNewLine(pageLines));
            pageLines.clear();
        }
        return pages;
    }

    public static List<IPage> pagesForLongText(FormattedText text, Ingredient ingredient) {
        List<FormattedText> pageText = PageHelper.prepareForLongText(text, 164, 81, 120);
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        for (int i = 0; i < pageText.size(); ++i) {
            if (i == 0) {
                pageList.add(new PageItemStack(pageText.get(i), ingredient));
                continue;
            }
            pageList.add(new PageText(pageText.get(i)));
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(FormattedText text) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        PageHelper.prepareForLongText(text, 164, 126, 126).forEach(t -> pageList.add(new PageText((FormattedText)t)));
        return pageList;
    }

    public static void drawFormattedText(GuiGraphics graphics, int x, int y, BaseScreen guiBase, FormattedText toDraw) {
        Font fontRenderer = Minecraft.getInstance().font;
        List cutLines = fontRenderer.split(toDraw, 170);
        for (FormattedCharSequence cut : cutLines) {
            graphics.drawString(fontRenderer, cut, x, y, 0, false);
            y += 10;
        }
    }

    public static List<IPage> pagesForLongText(FormattedText text, Item item) {
        return PageHelper.pagesForLongText(text, new ItemStack((ItemLike)item));
    }

    public static List<IPage> pagesForLongText(FormattedText text, Block block) {
        return PageHelper.pagesForLongText(text, new ItemStack((ItemLike)block));
    }

    public static List<IPage> pagesForLongText(FormattedText text, ItemStack item) {
        return PageHelper.pagesForLongText(text, Ingredient.of((ItemStack[])new ItemStack[]{item}));
    }

    public static boolean areIRecipesEqual(Recipe recipe1, Recipe recipe2, RegistryAccess registryAccess) {
        if (recipe1 == recipe2) {
            return true;
        }
        if (recipe1 == null || recipe2 == null || recipe1.getClass() != recipe2.getClass()) {
            return false;
        }
        if (recipe1.equals((Object)recipe2)) {
            return true;
        }
        return ItemStack.isSameItem((ItemStack)recipe1.getResultItem((HolderLookup.Provider)registryAccess), (ItemStack)recipe2.getResultItem((HolderLookup.Provider)registryAccess));
    }

    private static FormattedText combineWithNewLine(List<FormattedText> elements) {
        MutableComponent newLine = Component.literal((String)"\n");
        ArrayList<Object> copy = new ArrayList<Object>(elements.size() * 2);
        for (int i = 0; i < elements.size() - 1; ++i) {
            copy.add(elements.get(i));
            copy.add(newLine);
        }
        copy.add(elements.get(elements.size() - 1));
        return FormattedText.composite(copy);
    }
}

