/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GuiHelper {
    private static final ItemRenderer render = Minecraft.getInstance().getItemRenderer();

    public static boolean isMouseBetween(double mouseX, double mouseY, int x, int y, int width, int height) {
        int xSize = x + width;
        int ySize = y + height;
        return mouseX >= (double)x && mouseX <= (double)xSize && mouseY >= (double)y && mouseY <= (double)ySize;
    }

    public static void drawItemStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        PoseStack mStack = graphics.pose();
        mStack.pushPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y, null);
        mStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawScaledItemStack(GuiGraphics graphics, ItemStack stack, int x, int y, float scale) {
        PoseStack mStack = graphics.pose();
        mStack.pushPose();
        mStack.scale(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        RenderSystem.applyModelViewMatrix();
        graphics.renderItem(stack, (int)((float)x / scale), (int)((float)y / scale));
        mStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawSizedIconWithoutColor(GuiGraphics graphics, int x, int y, int width, int height, float zLevel) {
        PoseStack mStack = graphics.pose();
        mStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mStack.scale(0.5f, 0.5f, 0.5f);
        mStack.translate((float)x, (float)y, zLevel);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex((float)x, (float)(y + height), zLevel).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex((float)(x + width), (float)(y + height), zLevel).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex((float)(x + width), (float)y, zLevel).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex((float)x, (float)y, zLevel).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        mStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawSizedIconWithColor(GuiGraphics graphics, int x, int y, int width, int height, float zLevel, Color color) {
        PoseStack mStack = graphics.pose();
        mStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        mStack.scale(0.5f, 0.5f, 0.5f);
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        mStack.translate((float)x, (float)y, zLevel);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex((float)x, (float)(y + height), zLevel).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex((float)(x + width), (float)(y + height), zLevel).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex((float)(x + width), (float)y, zLevel).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex((float)x, (float)y, zLevel).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        mStack.pushPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static List<Component> getTooltip(ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        List list = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        for (int k = 0; k < list.size(); ++k) {
            Component c = (Component)list.get(k);
            if (!(c instanceof MutableComponent)) continue;
            if (k == 0) {
                ((MutableComponent)c).withStyle(stack.getRarity().getStyleModifier());
                continue;
            }
            ((MutableComponent)c).withStyle(ChatFormatting.GRAY);
        }
        return list;
    }
}

