/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class SubTexture {
    private static final ResourceLocation RECIPE_ELEMENTS = ResourceLocation.fromNamespaceAndPath((String)"guideapi_vp", (String)"textures/gui/recipe_elements.png");
    public static final SubTexture CRAFTING_GRID = new SubTexture(RECIPE_ELEMENTS, 0, 48, 102, 56);
    public static final SubTexture FURNACE_GRID = new SubTexture(RECIPE_ELEMENTS, 0, 104, 68, 28);
    public static final SubTexture POTION_GRID = new SubTexture(RECIPE_ELEMENTS, 0, 132, 68, 81);
    public static final SubTexture SINGLE_SLOT = new SubTexture(RECIPE_ELEMENTS, 0, 28, 20, 20);
    public static final SubTexture LARGE_BUTTON = new SubTexture(RECIPE_ELEMENTS, 0, 0, 55, 18);
    public static final SubTexture LARGE_BUTTON_HOVER = new SubTexture(RECIPE_ELEMENTS, 55, 0, 55, 18);
    public static final SubTexture LARGE_BUTTON_PRESS = new SubTexture(RECIPE_ELEMENTS, 110, 0, 55, 18);
    public static final SubTexture SMALL_BUTTON_BLANK = new SubTexture(RECIPE_ELEMENTS, 0, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_BLANK_HOVER = new SubTexture(RECIPE_ELEMENTS, 40, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_BLANK_PRESS = new SubTexture(RECIPE_ELEMENTS, 80, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_CRAFT = new SubTexture(RECIPE_ELEMENTS, 10, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_CRAFT_HOVER = new SubTexture(RECIPE_ELEMENTS, 50, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_CRAFT_PRESS = new SubTexture(RECIPE_ELEMENTS, 90, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_FURNACE = new SubTexture(RECIPE_ELEMENTS, 20, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_FURNACE_HOVER = new SubTexture(RECIPE_ELEMENTS, 60, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_FURNACE_PRESS = new SubTexture(RECIPE_ELEMENTS, 100, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_POTION = new SubTexture(RECIPE_ELEMENTS, 30, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_POTION_HOVER = new SubTexture(RECIPE_ELEMENTS, 70, 0, 10, 10);
    public static final SubTexture SMALL_BUTTON_POTION_PRESS = new SubTexture(RECIPE_ELEMENTS, 110, 0, 10, 10);
    private static final ResourceLocation OTHER_ELEMENTS = ResourceLocation.fromNamespaceAndPath((String)"guideapi_vp", (String)"textures/gui/book_colored.png");
    public static final SubTexture MAGNIFYING_GLASS = new SubTexture(OTHER_ELEMENTS, 0, 241, 15, 15);
    private final ResourceLocation textureLocation;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;

    public SubTexture(ResourceLocation textureLocation, int xPos, int yPos, int width, int height) {
        this.textureLocation = textureLocation;
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.height = height;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int drawX, int drawY, float zLevel) {
        Matrix4f matrix = graphics.pose().last().pose();
        float someMagicValueFromMojang = 0.00390625f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureLocation);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex((float)drawX, (float)(drawY + this.height), zLevel).setUv((float)this.xPos * 0.00390625f, (float)(this.yPos + this.height) * 0.00390625f);
        bufferBuilder.addVertex((float)(drawX + this.width), (float)(drawY + this.height), zLevel).setUv((float)(this.xPos + this.width) * 0.00390625f, (float)(this.yPos + this.height) * 0.00390625f);
        bufferBuilder.addVertex((float)(drawX + this.width), (float)drawY, zLevel).setUv((float)(this.xPos + this.width) * 0.00390625f, (float)this.yPos * 0.00390625f);
        bufferBuilder.addVertex((float)drawX, (float)drawY, zLevel).setUv((float)this.xPos * 0.00390625f, (float)this.yPos * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int drawX, int drawY) {
        this.draw(graphics, drawX, drawY, 0.1f);
    }

    public int getDrawX() {
        return this.xPos;
    }

    public int getDrawY() {
        return this.yPos;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public int getWidth() {
        return this.width;
    }
}

