/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi;

import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.impl.Book;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GuideConfig {
    public static Common COMMON;

    public static void buildConfiguration(IEventBus modBus) {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        ModConfigSpec commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue canSpawnWithBook;
        public final ModConfigSpec.BooleanValue enableLogging;
        public final Map<Book, ModConfigSpec.BooleanValue> SPAWN_BOOKS = new HashMap<Book, ModConfigSpec.BooleanValue>();

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Common configurations settings").push("common");
            this.enableLogging = builder.comment("Enables extra information being printed to the console.").define("enableLogging", true);
            this.canSpawnWithBook = builder.comment("Allows books to spawn with new players.\nThis is a global override for all books if set to false.").define("canSpawnWithBook", true);
            builder.comment("If the player should spawn with this book").push("spawnBook");
            for (Book book : GuideAPI.getBooks().values()) {
                this.SPAWN_BOOKS.put(book, builder.define(book.getRegistryName().getNamespace() + "-" + book.getRegistryName().getPath(), book.shouldSpawnWithBook()));
            }
            builder.pop();
            builder.pop();
        }
    }
}

