/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.render;

import com.matyrobbrt.keybindbundles.KBClientConfig;
import com.matyrobbrt.keybindbundles.KeyBindBundle;
import com.matyrobbrt.keybindbundles.KeyBindBundleManager;
import com.matyrobbrt.keybindbundles.KeyMappingUtil;
import com.matyrobbrt.keybindbundles.render.RadialMenuRenderer;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class KeybindSelectionOverlay
extends RadialMenuRenderer<KeyBindBundle.KeyEntry>
implements LayeredDraw.Layer {
    public static final KeybindSelectionOverlay INSTANCE = new KeybindSelectionOverlay();
    @Nullable
    private KeyBindBundle displayedKeybind;
    private KeyBindBundleManager.RadialKeyMapping displayedMapping;
    @Nullable
    private KeyMapping currentlyPressing;

    @Override
    public Component getTitle(KeyBindBundle.KeyEntry entry) {
        return Component.literal((String)entry.title());
    }

    @Override
    public ItemStack getIcon(KeyBindBundle.KeyEntry entry) {
        return entry.icon();
    }

    @Override
    public List<KeyBindBundle.KeyEntry> getEntries() {
        return this.displayedKeybind == null ? List.of() : this.displayedKeybind.getEntries();
    }

    @Override
    public int getCurrentlySelected() {
        return this.displayedKeybind.getBookmark();
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (this.displayedKeybind == null) {
            return;
        }
        super.render(guiGraphics, true);
        if (KBClientConfig.CLIP_MOUSE_TO_MENU.getAsBoolean()) {
            Window mainWindow = Minecraft.getInstance().getWindow();
            int windowWidth = mainWindow.getScreenWidth();
            int windowHeight = mainWindow.getScreenHeight();
            double[] xPos = new double[1];
            double[] yPos = new double[1];
            GLFW.glfwGetCursorPos((long)mainWindow.getWindow(), (double[])xPos, (double[])yPos);
            double scaledX = xPos[0] - (double)((float)windowWidth / 2.0f);
            double scaledY = yPos[0] - (double)((float)windowHeight / 2.0f);
            double distance = Math.sqrt(scaledX * scaledX + scaledY * scaledY);
            double radius = 100.0 * ((double)windowWidth / (double)mainWindow.getGuiScaledWidth()) * 1.1;
            if (distance > radius) {
                double fixedX = scaledX * radius / distance;
                double fixedY = scaledY * radius / distance;
                GLFW.glfwSetCursorPos((long)mainWindow.getWindow(), (double)((int)((double)(windowWidth / 2) + fixedX)), (double)((int)((double)(windowHeight / 2) + fixedY)));
            }
        }
    }

    public void mouseClick(double mouseX, double mouseY, int button, int action) {
        KeyMapping key;
        float centerY;
        double yDiff;
        Window window;
        float centerX;
        double xDiff;
        double distanceFromCenter;
        KeyBindBundle displayedKeybind = this.displayedKeybind;
        if (displayedKeybind == null) {
            return;
        }
        if (button == 0 && this.currentlyPressing != null && action == 0) {
            KeyMappingUtil.release(this.currentlyPressing);
            this.currentlyPressing = null;
        }
        if ((distanceFromCenter = Mth.length((double)(xDiff = mouseX - (double)(centerX = (float)(window = Minecraft.getInstance().getWindow()).getGuiScaledWidth() / 2.0f)), (double)(yDiff = mouseY - (double)(centerY = (float)window.getGuiScaledHeight() / 2.0f)))) < 10.0 || distanceFromCenter > 100.0) {
            return;
        }
        int selectionIndex = this.getElementUnderMouse(false);
        if (button == 1 && action == 0) {
            if (selectionIndex == displayedKeybind.getBookmark()) {
                displayedKeybind.setBookmark(-1);
            } else {
                displayedKeybind.setBookmark(selectionIndex);
            }
            KeyBindBundleManager.write();
        } else if (button == 0 && (key = KeyMappingUtil.getByName(displayedKeybind.getEntries().get(selectionIndex).key())) != null && action == 1) {
            KeyMappingUtil.press(key);
            KeyMappingUtil.click(key);
            this.currentlyPressing = key;
        }
    }

    @Nullable
    public KeyBindBundle getDisplayedKeybind() {
        return this.displayedKeybind;
    }

    @Nullable
    public KeyBindBundleManager.RadialKeyMapping getDisplayedMapping() {
        return this.displayedMapping;
    }

    public void open(KeyBindBundleManager.RadialKeyMapping mapping) {
        this.displayedKeybind = mapping.bind;
        this.displayedMapping = mapping;
    }

    public void close() {
        KeyMapping key;
        int idx;
        KeyBindBundle kb = this.displayedKeybind;
        if (kb != null && KBClientConfig.TRIGGER_KEYMAPPING_ON_RELEASE.getAsBoolean() && (idx = this.getElementUnderMouse(false)) >= 0 && (key = KeyMappingUtil.getByName(this.displayedKeybind.getEntries().get(idx).key())) != null) {
            KeyMappingUtil.press(key);
            KeyMappingUtil.click(key);
            Minecraft.getInstance().execute(() -> KeyMappingUtil.release(key));
        }
        this.displayedKeybind = null;
        this.displayedMapping = null;
        this.clearState();
        KeyMappingUtil.restoreAll();
    }
}

