/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.render;

import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class EditBoxScreen
extends Screen {
    private final Component message;
    private MultiLineLabel multilineMessage = MultiLineLabel.EMPTY;
    protected final Consumer<String> callback;

    public EditBoxScreen(Consumer<String> callback, Component title, Component message) {
        super(title);
        this.callback = callback;
        this.message = message;
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.message});
    }

    protected void init() {
        super.init();
        this.multilineMessage = MultiLineLabel.create((Font)this.font, (Component)this.message, (int)(this.width - 50));
        int y = Mth.clamp((int)(this.messageTop() + this.messageHeight() + 20), (int)(this.height / 6 + 96), (int)(this.height - 24));
        1 box = this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, this.width / 2 - 75, y, 150, 20, this.message){

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257) {
                    EditBoxScreen.this.callback.accept(this.getValue());
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
        });
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, p -> this.callback.accept(box.getValue())).size(50, 20).pos(this.width / 2 - 25, y + 25).build());
        this.setFocused((GuiEventListener)box);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.titleTop(), 0xFFFFFF);
        this.multilineMessage.renderCentered(guiGraphics, this.width / 2, this.messageTop());
    }

    private int titleTop() {
        int i = (this.height - this.messageHeight()) / 2;
        return Mth.clamp((int)(i - 20 - 9), (int)10, (int)80);
    }

    private int messageTop() {
        return this.titleTop() + 20;
    }

    private int messageHeight() {
        return this.multilineMessage.getLineCount() * 9;
    }
}

