/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.datagen;

import com.mrbysco.structurecompass.registry.StructureItems;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CompassDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new CompassRecipeProvider(packOutput, lookupProvider));
            CompassBlockTagProvider blockTags = new CompassBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTags);
            generator.addProvider(event.includeServer(), (DataProvider)new CompassItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new CompassLangProvider(packOutput));
        }
    }

    public static class CompassRecipeProvider
    extends RecipeProvider {
        public CompassRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput recipeOutput) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)StructureItems.STRUCTURE_COMPASS.get())).pattern("WTS").pattern("O#D").pattern("MCP").define(Character.valueOf('#'), (ItemLike)Items.COMPASS).define(Character.valueOf('W'), (ItemLike)Blocks.SNOW_BLOCK).define(Character.valueOf('T'), (ItemLike)Blocks.TERRACOTTA).define(Character.valueOf('S'), (ItemLike)Blocks.SANDSTONE).define(Character.valueOf('O'), (ItemLike)Blocks.OAK_LOG).define(Character.valueOf('D'), (ItemLike)Blocks.DARK_OAK_LOG).define(Character.valueOf('M'), (ItemLike)Blocks.MOSSY_COBBLESTONE).define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('P'), (ItemLike)Blocks.CARVED_PUMPKIN).unlockedBy("has_compass", CompassRecipeProvider.has((ItemLike)Items.COMPASS)).save(recipeOutput);
        }
    }

    public static class CompassBlockTagProvider
    extends BlockTagsProvider {
        public CompassBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @javax.annotation.Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "structurecompass", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
        }
    }

    public static class CompassItemTagProvider
    extends ItemTagsProvider {
        public CompassItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, TagsProvider<Block> blockTagProvider, ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagProvider.contentsGetter(), "structurecompass", existingFileHelper);
        }

        public void addTags(HolderLookup.Provider lookupProvider) {
            this.tag(ItemTags.COMPASSES).add((Object)((Item)StructureItems.STRUCTURE_COMPASS.get()));
        }
    }

    public static class CompassLangProvider
    extends LanguageProvider {
        public CompassLangProvider(PackOutput packOutput) {
            super(packOutput, "structurecompass", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.structurecompass", "Structure Compass");
            this.addItem((Supplier)StructureItems.STRUCTURE_COMPASS, "Structure Compass");
            this.add("structurecompass.screen.selection.title", "Structure Selection");
            this.add("structurecompass.screen.selection.select", "Select");
            this.add("structurecompass.screen.selection.selected", "Structure selected, right-click the compass to locate it");
            this.add("structurecompass.screen.search", "Search");
            this.add("structurecompass.screen.search.a_to_z", "A-Z");
            this.add("structurecompass.screen.search.z_to_a", "Z-A");
            this.add("structurecompass.locate.invalid", "Bound structure invalid. Please re-bind");
            this.add("structurecompass.locate.fail", "Bound structure could not be located nearby");
            this.add("structurecompass.locate.distance", "Bound structure is %s blocks away");
            this.add("structurecompass.locate.toggled", "Structure Compass hud toggled %s");
            this.add("structurecompass.structure.locating", "Attempting to locate %s, please wait...");
            this.add("structurecompass.structure.found", "%s has been located %s blocks away, compass is pointing towards the structure");
            this.add("structurecompass.structure.found.tooltip", "%s has been located, compass is pointing towards the structure");
            this.add("structurecompass.structure.failed", "%s can not be located within a %s block radius. Please explore further and try again later");
            this.add("structurecompass.structure.failed.tooltip", "%s can not be located, perhaps try again later");
            this.add("structurecompass.structure.wrong_dimension.tooltip", "You are not in the dimension in which %s was found");
            this.add("structurecompass.structure.unset.tooltip", "No structure has been set, shift right-click to select a structure");
            this.add("category.structurecompass.main", "Structure Compass");
            this.add("key.structurecompass.hide", "Hide Structure Compass HUD");
            this.add("structurecompass.networking.set_structure.failed", "Failed to set structure: %s");
            this.addConfig("title", "Structure Compass Config", null);
            this.addConfig("general", "General", "General Settings");
            this.addConfig("compassRange", "Compass Range", "Sets the range in blocks in which the structure compasses can locate structures");
            this.addConfig("locateUnexplored", "Locate Unexplored", "Defines if the structure compass should only locate unexplored structures. A structure is tagged as explored when the compass is used to find it.");
            this.addConfig("locateAsync", "Locate Asynchronously", "Defines if the structure compass should locate structures asynchronously");
            this.addConfig("structureBlacklist", "Structure Blacklist", "Defines which structures can't be searched with the Structure Compass\n(Supports wildcard *, Example: 'minecraft:*' will blacklist anything in the minecraft domain)");
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("structurecompass.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("structurecompass.configuration." + path + ".tooltip", description);
            }
        }
    }
}

