/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.jearchaeology.JEArchaeology;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SniffRecipe
implements Recipe<RecipeInput> {
    public final Ingredient item;
    public final float chance;

    public SniffRecipe(Ingredient item, float chance) {
        this.item = item;
        this.chance = chance;
    }

    public boolean matches(RecipeInput inv, Level levelIn) {
        return false;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)JEArchaeology.SNIFF.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)JEArchaeology.SNIFF_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SniffRecipe> {
        private static final MapCodec<SniffRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("item").forGetter(recipe -> recipe.item), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(0.05f)).forGetter(recipe -> Float.valueOf(recipe.chance))).apply((Applicative)builder, SniffRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SniffRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SniffRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SniffRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static SniffRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new SniffRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), buffer.readFloat());
            }
            catch (Exception e) {
                JEArchaeology.LOGGER.error("Error reading sniff recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, SniffRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.item);
                buffer.writeFloat(recipe.chance);
            }
            catch (Exception e) {
                JEArchaeology.LOGGER.error("Error writing sniff recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

