/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;

public final class CodecUtil {
    public static final StreamCodec<ByteBuf, InteractionHand> INTERACTION_HAND_STREAM_CODEC = ByteBufCodecs.BOOL.map(bool -> bool != false ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, hand -> hand == InteractionHand.MAIN_HAND);

    public static <E extends Enum<E>> Codec<E> enumCodec(Supplier<E[]> valuesSupplier) {
        return StringRepresentable.fromEnum(valuesSupplier);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> enumStreamCodec(Supplier<E[]> valuesSupplier, Function<E, Integer> ordinalSupplier) {
        return ByteBufCodecs.VAR_INT.map(e -> ((Enum[])valuesSupplier.get())[e], ordinalSupplier);
    }

    public static <B extends ByteBuf, K, V> StreamCodec<B, Map<K, V>> mapStreamCodec(StreamCodec<? super B, K> keyCodec, StreamCodec<? super B, V> valueCodec) {
        return ByteBufCodecs.map(HashMap::new, keyCodec, valueCodec);
    }

    public static <T> StreamCodec<FriendlyByteBuf, T> toStreamCodec(final Codec<T> codec) {
        return new StreamCodec<FriendlyByteBuf, T>(){

            public void encode(FriendlyByteBuf buffer, T value) {
                buffer.writeUtf(CodecUtil.encodeJson(codec, value).toString());
            }

            public T decode(FriendlyByteBuf buffer) {
                return CodecUtil.decodeJson(codec, JsonParser.parseString((String)buffer.readUtf()));
            }
        };
    }

    public static <T> Tag encodeNbt(Codec<T> codec, T value) {
        return (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).getOrThrow();
    }

    public static <T> T decodeNbt(Codec<T> codec, Tag tag) {
        return (T)((Pair)codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow()).getFirst();
    }

    public static <T> JsonElement encodeJson(Codec<T> codec, T value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
    }

    public static <T> T decodeJson(Codec<T> codec, JsonElement json) {
        return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
    }
}

