/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.item;

import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.DataAttachmentRegistry;
import io.redspace.ironsjewelry.registry.ItemRegistry;
import io.redspace.ironsjewelry.utils.MinecraftInstanceHelper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PatternRecipeItem
extends Item {
    public PatternRecipeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (stack.has(ComponentRegistry.STORED_PATTERN)) {
            Holder pattern = (Holder)stack.get(ComponentRegistry.STORED_PATTERN);
            PlayerData playerData = (PlayerData)pPlayer.getData(DataAttachmentRegistry.PLAYER_DATA);
            if (!playerData.isLearned((Holder<PatternDefinition>)pattern)) {
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    playerData.learnAndSync(serverPlayer, (Holder<PatternDefinition>)pattern);
                    if (!pPlayer.isCreative()) {
                        stack.shrink(1);
                        pPlayer.setItemInHand(pUsedHand, stack);
                    }
                } else {
                    pPlayer.playSound(SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, 1.0f, 1.0f);
                    pPlayer.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                }
                return InteractionResultHolder.consume((Object)stack);
            }
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)pPlayer;
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.irons_jewelry.pattern_already_learned", (Object[])new Object[]{Component.translatable((String)((PatternDefinition)pattern.value()).descriptionId())}).withStyle(ChatFormatting.RED)));
            } else {
                pPlayer.playSound(SoundEvents.BOOK_PAGE_TURN, 1.0f, 1.0f);
            }
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(stack, pContext, pTooltipComponents, pTooltipFlag);
        if (stack.has(ComponentRegistry.STORED_PATTERN)) {
            Holder pattern = (Holder)stack.get(ComponentRegistry.STORED_PATTERN);
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.irons_jewelry.stored_pattern", (Object[])new Object[]{Component.translatable((String)((PatternDefinition)pattern.value()).descriptionId()).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.GRAY));
            Player player = MinecraftInstanceHelper.getPlayer();
            if (player != null) {
                PlayerData playerData = PlayerData.get(player);
                if (!playerData.isLearned((Holder<PatternDefinition>)pattern)) {
                    pTooltipComponents.add((Component)Component.translatable((String)"tooltip.irons_jewelry.use_to_learn", (Object[])new Object[]{Component.keybind((String)"key.use")}).withStyle(ChatFormatting.BLUE));
                } else {
                    pTooltipComponents.add((Component)Component.translatable((String)"tooltip.irons_jewelry.already_learned").withStyle(ChatFormatting.RED));
                }
            }
        }
    }

    public static ItemStack of(Holder<PatternDefinition> patternDefinitionHolder) {
        ItemStack stack = new ItemStack(ItemRegistry.RECIPE);
        stack.set(ComponentRegistry.STORED_PATTERN, patternDefinitionHolder);
        return stack;
    }
}

