/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.actions.IAction;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import io.redspace.ironsjewelry.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record ApplyFreezeAction(QualityScalar amount, boolean instaFreeze) implements IAction
{
    public static final MapCodec<ApplyFreezeAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)QualityScalar.CODEC.fieldOf("amount").forGetter(ApplyFreezeAction::amount), (App)Codec.BOOL.optionalFieldOf("instaFreeze", (Object)false).forGetter(ApplyFreezeAction::instaFreeze)).apply((Applicative)builder, ApplyFreezeAction::new));

    @Override
    public void apply(ServerLevel serverLevel, double quality, boolean applyToSelf, ServerPlayer wearer, Entity entity) {
        ServerPlayer target = applyToSelf ? wearer : entity;
        int freezeTicks = this.getFreezeTicks(quality) * 2;
        int maxTicks = freezeTicks * 2;
        int instaFreeze = target.isFullyFrozen() ? 0 : target.getTicksRequiredToFreeze();
        target.setTicksFrozen(instaFreeze + Math.min(target.getTicksFrozen() + freezeTicks, maxTicks));
    }

    public int getFreezeTicks(double quality) {
        return (int)this.amount.sample(quality);
    }

    @Override
    public Component formatTooltip(BonusInstance bonusInstance, boolean applyToSelf) {
        Object translation = "action.irons_jewelry.apply_freeze";
        translation = (String)translation + (this.instaFreeze ? ".freeze" : ".add");
        translation = (String)translation + (applyToSelf ? ".self" : ".entity");
        return Component.translatable((String)translation, (Object[])new Object[]{Component.literal((String)Utils.timeFromTicks(this.getFreezeTicks(bonusInstance.quality()), 0)).withStyle(applyToSelf ? ChatFormatting.RED : ChatFormatting.GREEN)});
    }

    @Override
    public MapCodec<? extends IAction> codec() {
        return CODEC;
    }
}

