/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.client;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import io.redspace.atlasapi.api.AssetHandler;
import io.redspace.atlasapi.api.data.BakingPreparations;
import io.redspace.atlasapi.api.data.ModelLayer;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JewelryAssetHandler
extends AssetHandler {
    private static PartIngredient get(Holder<PartDefinition> definition, List<PartIngredient> list) {
        for (PartIngredient i : list) {
            if (!i.part().equals(definition)) continue;
            return i;
        }
        return null;
    }

    @NotNull
    public BakingPreparations makeBakedModelPreparations(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int seed) {
        Set<Map.Entry<Holder<PartDefinition>, Holder<MaterialDefinition>>> parts;
        JewelryData jewelryData = JewelryData.get(itemStack);
        if (jewelryData.isValid() && !(parts = jewelryData.parts().entrySet()).isEmpty()) {
            List<ModelLayer> layers = parts.stream().map(part -> {
                ResourceLocation sprite = this.getSpriteLocation((Holder<PartDefinition>)((Holder)part.getKey()), (Holder<MaterialDefinition>)((Holder)part.getValue()));
                return new ModelLayer(sprite, JewelryAssetHandler.get((Holder<PartDefinition>)((Holder)part.getKey()), ((PatternDefinition)jewelryData.pattern().value()).partTemplate()).drawOrder(), Optional.empty());
            }).toList();
            return new BakingPreparations(layers);
        }
        return new BakingPreparations(List.of());
    }

    public String getPermutationName(Holder<MaterialDefinition> material) {
        ResourceLocation materialKey = material.getKey().location();
        String materialName = JewelryAssetHandler.splitEnd(materialKey.getPath());
        return String.format("%s_%s", materialKey.getNamespace(), materialName);
    }

    public ResourceLocation getSpriteLocation(Holder<PartDefinition> part, Holder<MaterialDefinition> material) {
        try {
            String base = ((PartDefinition)part.value()).baseTextureLocation().toString();
            String permutationName = this.getPermutationName(material);
            return ResourceLocation.parse((String)String.format("%s_%s", base, permutationName));
        }
        catch (ResourceLocationException exception) {
            IronsJewelry.LOGGER.error("Error parsing atlas sprite location: {}", (Object)exception.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ResourceLocation.withDefaultNamespace((String)"missingno");
    }

    public ResourceLocation getMenuSpriteLocation(Holder<PartDefinition> partDefinition, boolean bright) {
        return ResourceLocation.parse((String)String.format("%s_%s", ((PartDefinition)partDefinition.value()).baseTextureLocation().toString(), bright ? "menu_bright" : "menu"));
    }

    public List<SpriteSource> buildSpriteSources() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        ArrayList<SpriteSource> sources = new ArrayList<SpriteSource>();
        LinkedListMultimap byPaletteKey = LinkedListMultimap.create();
        HashMap<String, ResourceLocation> permutations = new HashMap<String, ResourceLocation>(Map.of("menu", IronsJewelry.id("palettes/menu"), "menu_bright", IronsJewelry.id("palettes/menu_bright")));
        IronsJewelryRegistries.materialRegistry(Minecraft.getInstance().level.registryAccess()).holders().forEach(material -> {
            ResourceLocation palette = ((MaterialDefinition)material.value()).paletteLocation();
            if (resourceManager.getResource(palette.withPrefix("textures/").withSuffix(".png")).isEmpty()) {
                IronsJewelry.LOGGER.warn("Invalid palette: \"{}\" in material: {}", (Object)palette, (Object)material.key().location());
            } else {
                permutations.put(this.getPermutationName((Holder<MaterialDefinition>)material), palette);
            }
        });
        IronsJewelryRegistries.partRegistry(Minecraft.getInstance().level.registryAccess()).holders().forEach(arg_0 -> JewelryAssetHandler.lambda$buildSpriteSources$2(resourceManager, (Multimap)byPaletteKey, arg_0));
        for (ResourceLocation paletteKey : byPaletteKey.keySet()) {
            List entries = byPaletteKey.get((Object)paletteKey).stream().toList();
            sources.add((SpriteSource)new PalettedPermutations(entries, paletteKey, permutations));
        }
        return sources;
    }

    private static String splitEnd(String string) {
        String[] a = string.split("/");
        return a[a.length - 1];
    }

    public int modelId(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int seed) {
        return JewelryData.get(itemStack).hashCode();
    }

    private static /* synthetic */ void lambda$buildSpriteSources$2(ResourceManager resourceManager, Multimap byPaletteKey, Holder.Reference part) {
        ResourceLocation paletteKey = ((PartDefinition)part.value()).paletteKey();
        ResourceLocation texture = ((PartDefinition)part.value()).baseTextureLocation();
        if (resourceManager.getResource(paletteKey.withPrefix("textures/").withSuffix(".png")).isEmpty()) {
            IronsJewelry.LOGGER.warn("Invalid palette key: \"{}\" in part: {}", (Object)paletteKey, (Object)part.key().location());
        } else if (resourceManager.getResource(texture.withPrefix("textures/").withSuffix(".png")).isEmpty()) {
            IronsJewelry.LOGGER.warn("Invalid texture location: \"{}\" in part: {}", (Object)texture, (Object)part.key().location());
        } else {
            byPaletteKey.put((Object)paletteKey, (Object)texture);
        }
    }
}

