/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ItemNBTUtil {
    public static void updateItemNBTFromEntity(ItemStack stack, SpiritEntity entity) {
        ItemNBTUtil.setWorkAreaPosition(stack, entity.getWorkAreaPosition());
        ItemNBTUtil.setDepositPosition(stack, entity.getDepositPosition());
        ItemNBTUtil.setDepositEntityUUID(stack, entity.getDepositEntityUUID());
        ItemNBTUtil.setDepositFacing(stack, entity.getDepositFacing());
        ItemNBTUtil.setExtractPosition(stack, entity.getExtractPosition());
        ItemNBTUtil.setExtractFacing(stack, entity.getExtractFacing());
        ItemNBTUtil.setWorkAreaSize(stack, entity.getWorkAreaSize());
        entity.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast).ifPresent(job -> {
            if (job.getStorageControllerPosition() != null) {
                ItemNBTUtil.setStorageControllerPosition(stack, job.getStorageControllerPosition());
            }
            if (job.getManagedMachine() != null) {
                ItemNBTUtil.setManagedMachine(stack, job.getManagedMachine());
            }
        });
    }

    public static void generateBoundSpiritNameIfNone(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.SPIRIT_NAME) || ((String)stack.get(OccultismDataComponents.SPIRIT_NAME)).isEmpty() || ((String)stack.get(OccultismDataComponents.SPIRIT_NAME)).equals("(Not yet known)")) {
            ItemNBTUtil.generateBoundSpiritName(stack);
        }
    }

    public static void generateBoundSpiritName(ItemStack stack) {
        ItemNBTUtil.setBoundSpiritName(stack, TextUtil.generateName());
    }

    public static void setBoundSpiritName(ItemStack stack, String name) {
        stack.set(OccultismDataComponents.SPIRIT_NAME, (Object)name);
    }

    public static String getBoundSpiritName(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.SPIRIT_NAME)) {
            ItemNBTUtil.generateBoundSpiritName(stack);
        }
        return (String)stack.get(OccultismDataComponents.SPIRIT_NAME);
    }

    public static int getItemMode(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.ITEM_MODE)) {
            ItemNBTUtil.setItemMode(stack, 0);
        }
        return (Integer)stack.get(OccultismDataComponents.ITEM_MODE);
    }

    public static void setItemMode(ItemStack stack, int mode) {
        stack.set(OccultismDataComponents.ITEM_MODE, (Object)mode);
    }

    public static GlobalBlockPos getStorageControllerPosition(ItemStack stack) {
        return (GlobalBlockPos)stack.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER);
    }

    public static void setStorageControllerPosition(ItemStack stack, GlobalBlockPos position) {
        if (position != null) {
            stack.set(OccultismDataComponents.LINKED_STORAGE_CONTROLLER, (Object)position);
        }
    }

    public static MachineReference getManagedMachine(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.MANAGED_MACHINE)) {
            return null;
        }
        return (MachineReference)stack.get(OccultismDataComponents.MANAGED_MACHINE);
    }

    public static void setManagedMachine(ItemStack stack, MachineReference position) {
        if (position != null) {
            stack.set(OccultismDataComponents.MANAGED_MACHINE, (Object)position);
        }
    }

    public static BlockPos getDepositPosition(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.DEPOSIT_POSITION)) {
            return null;
        }
        return (BlockPos)stack.get(OccultismDataComponents.DEPOSIT_POSITION);
    }

    public static void setDepositPosition(ItemStack stack, Optional<BlockPos> position) {
        if (position.isPresent()) {
            stack.set(OccultismDataComponents.DEPOSIT_POSITION, (Object)position.get());
        } else if (stack.has(OccultismDataComponents.DEPOSIT_POSITION)) {
            stack.remove(OccultismDataComponents.DEPOSIT_POSITION);
        }
    }

    public static UUID getDepositEntityUUID(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.DEPOSIT_ENTITY_UUID)) {
            return null;
        }
        return (UUID)stack.get(OccultismDataComponents.DEPOSIT_ENTITY_UUID);
    }

    public static void setDepositEntityUUID(ItemStack stack, Optional<UUID> uuid) {
        if (uuid.isPresent()) {
            stack.set(OccultismDataComponents.DEPOSIT_ENTITY_UUID, (Object)uuid.get());
        } else if (stack.has(OccultismDataComponents.DEPOSIT_ENTITY_UUID)) {
            stack.remove(OccultismDataComponents.DEPOSIT_ENTITY_UUID);
        }
    }

    public static void setDepositEntityName(ItemStack stack, String string) {
        stack.set(OccultismDataComponents.DEPOSIT_ENTITY_NAME, (Object)string);
    }

    public static String getDepositEntityName(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.DEPOSIT_ENTITY_NAME)) {
            return null;
        }
        return (String)stack.get(OccultismDataComponents.DEPOSIT_ENTITY_NAME);
    }

    public static Direction getDepositFacing(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.DEPOSIT_FACING)) {
            return null;
        }
        return (Direction)stack.get(OccultismDataComponents.DEPOSIT_FACING);
    }

    public static void setDepositFacing(ItemStack stack, Direction facing) {
        stack.set(OccultismDataComponents.DEPOSIT_FACING, (Object)facing);
    }

    public static BlockPos getExtractPosition(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.EXTRACT_POS)) {
            return null;
        }
        return (BlockPos)stack.get(OccultismDataComponents.EXTRACT_POS);
    }

    public static void setExtractPosition(ItemStack stack, Optional<BlockPos> position) {
        if (position.isPresent()) {
            stack.set(OccultismDataComponents.EXTRACT_POS, (Object)position.get());
        } else if (stack.has(OccultismDataComponents.EXTRACT_POS)) {
            stack.remove(OccultismDataComponents.EXTRACT_POS);
        }
    }

    public static Direction getExtractFacing(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.EXTRACT_FACING)) {
            return null;
        }
        return (Direction)stack.get(OccultismDataComponents.EXTRACT_FACING);
    }

    public static void setExtractFacing(ItemStack stack, Direction facing) {
        stack.set(OccultismDataComponents.EXTRACT_FACING, (Object)facing);
    }

    public static BlockPos getWorkAreaPosition(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.WORK_AREA_POS)) {
            return null;
        }
        return (BlockPos)stack.get(OccultismDataComponents.WORK_AREA_POS);
    }

    public static void setWorkAreaPosition(ItemStack stack, Optional<BlockPos> position) {
        if (position.isPresent()) {
            stack.set(OccultismDataComponents.WORK_AREA_POS, (Object)position.get());
        } else if (stack.has(OccultismDataComponents.WORK_AREA_POS)) {
            stack.remove(OccultismDataComponents.WORK_AREA_POS);
        }
    }

    public static WorkAreaSize getWorkAreaSize(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.WORK_AREA_SIZE)) {
            ItemNBTUtil.setWorkAreaSize(stack, WorkAreaSize.SMALL);
        }
        return (WorkAreaSize)((Object)stack.get(OccultismDataComponents.WORK_AREA_SIZE));
    }

    public static void setWorkAreaSize(ItemStack stack, WorkAreaSize workAreaSize) {
        stack.set(OccultismDataComponents.WORK_AREA_SIZE, (Object)workAreaSize);
    }

    public static UUID getSpiritEntityUUID(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.SPIRIT_ENTITY_UUID)) {
            return null;
        }
        return (UUID)stack.get(OccultismDataComponents.SPIRIT_ENTITY_UUID);
    }

    public static void setSpiritEntityUUID(ItemStack stack, UUID id) {
        stack.set(OccultismDataComponents.SPIRIT_ENTITY_UUID, (Object)id);
    }

    public static boolean getSpiritDead(ItemStack stack) {
        return (Boolean)stack.getOrDefault(OccultismDataComponents.SPIRIT_DEAD, (Object)false);
    }

    public static CompoundTag getSpiritEntityData(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.SPIRIT_ENTITY_DATA)) {
            return null;
        }
        return ((CustomData)stack.get(OccultismDataComponents.SPIRIT_ENTITY_DATA)).getUnsafe();
    }

    public static void setSpiritEntityData(ItemStack stack, CompoundTag entityData) {
        stack.set(OccultismDataComponents.SPIRIT_ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
    }

    public static Optional<SpiritEntity> getSpiritEntity(ItemStack itemStack) {
        return EntityUtil.getEntityByUuiDGlobal(ItemNBTUtil.getSpiritEntityUUID(itemStack)).map(e -> (SpiritEntity)e);
    }
}

