/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.item.IHandleItemMode;
import com.klikli_dev.occultism.network.IMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MessageSetItemMode
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_item_mode");
    public static final CustomPacketPayload.Type<MessageSetItemMode> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetItemMode> STREAM_CODEC = CustomPacketPayload.codec(MessageSetItemMode::encode, MessageSetItemMode::new);
    public int mode;

    public MessageSetItemMode(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetItemMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Item item = stack.getItem();
        if (item instanceof IHandleItemMode) {
            IHandleItemMode itemModeHandler = (IHandleItemMode)item;
            itemModeHandler.setItemMode(stack, this.mode);
            player.inventoryMenu.broadcastChanges();
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.mode);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.mode = buf.readInt();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

