/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.network.IMessage;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MessageSelectBlock
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"select_block");
    public static final CustomPacketPayload.Type<MessageSelectBlock> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSelectBlock> STREAM_CODEC = CustomPacketPayload.codec(MessageSelectBlock::encode, MessageSelectBlock::new);
    public BlockPos blockPos;
    public int durationMilliseconds;
    public int color;

    public MessageSelectBlock(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSelectBlock(BlockPos blockPos, int durationMilliseconds, int color) {
        this.blockPos = blockPos;
        this.durationMilliseconds = durationMilliseconds;
        this.color = color;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Color color = new Color(this.color);
        Occultism.SELECTED_BLOCK_RENDERER.selectBlock(this.blockPos, System.currentTimeMillis() + (long)this.durationMilliseconds, color);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.durationMilliseconds);
        buf.writeInt(this.color);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
        this.durationMilliseconds = buf.readInt();
        this.color = buf.readInt();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

