/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe;

import com.klikli_dev.occultism.crafting.recipe.BoundBookOfBindingRecipe;
import com.klikli_dev.occultism.datagen.recipe.MinerRecipes;
import com.klikli_dev.occultism.datagen.recipe.RitualRecipes;
import com.klikli_dev.occultism.datagen.recipe.SpiritJobRecipes;
import com.klikli_dev.occultism.datagen.recipe.builders.SpiritFireRecipeBuilder;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class OccultismRecipeProvider
extends RecipeProvider {
    public OccultismRecipeProvider(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(p_248933_, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput, HolderLookup.Provider holderLookup) {
        this.ritualRecipes(pRecipeOutput, holderLookup);
        this.miningRecipes(pRecipeOutput);
        this.spiritJobRecipes(pRecipeOutput);
        this.craftingRecipes(pRecipeOutput);
        OccultismRecipeProvider.woodRecipes(pRecipeOutput);
        OccultismRecipeProvider.smeltingRecipes(pRecipeOutput);
        OccultismRecipeProvider.oresCookingRecipes(pRecipeOutput);
        OccultismRecipeProvider.spiritFireRecipes(pRecipeOutput);
        OccultismRecipeProvider.stonecutterRecipes(pRecipeOutput);
        OccultismRecipeProvider.otherflowerRecipes(pRecipeOutput);
        OccultismRecipeProvider.grayPasteRecipes(pRecipeOutput);
    }

    private void ritualRecipes(RecipeOutput recipeOutput, HolderLookup.Provider registries) {
        RitualRecipes.ritualRecipes(recipeOutput, registries);
    }

    private void miningRecipes(RecipeOutput pRecipeOutput) {
        MinerRecipes.minerRecipes(pRecipeOutput);
    }

    private void spiritJobRecipes(RecipeOutput pRecipeOutput) {
        SpiritJobRecipes.spiritJobRecipes(pRecipeOutput);
    }

    private static void metalRecipes(RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.IESNIUM_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.IESNIUM_INGOT).unlockedBy("has_iesnium_ingot", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_IESNIUM).unlockedBy("has_iesnium_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_ingot_from_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.IESNIUM_NUGGET).unlockedBy("has_iesnium_nugget", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_NUGGET)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_ingot_from_nuggets"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_NUGGET.get()), (int)9).requires(OccultismTags.Items.IESNIUM_INGOT).unlockedBy("has_iesnium_ingot", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_nugget"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.RAW_IESNIUM_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.RAW_IESNIUM).unlockedBy("has_raw_iesnium", OccultismRecipeProvider.has(OccultismTags.Items.RAW_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_iesnium_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.RAW_IESNIUM.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM).unlockedBy("has_raw_iesnium_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_iesnium_ingot_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.NETHERITE_DUST.get())).requires(OccultismTags.Items.NETHERITE_SCRAP_DUST).requires(OccultismTags.Items.NETHERITE_SCRAP_DUST).requires(OccultismTags.Items.NETHERITE_SCRAP_DUST).requires(OccultismTags.Items.NETHERITE_SCRAP_DUST).requires(OccultismTags.Items.GOLD_DUST).requires(OccultismTags.Items.GOLD_DUST).requires(OccultismTags.Items.GOLD_DUST).requires(OccultismTags.Items.GOLD_DUST).unlockedBy("has_netherite_scrap_dust", OccultismRecipeProvider.has(OccultismTags.Items.NETHERITE_SCRAP_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/netherite_dust"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.SILVER_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.SILVER_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_SILVER).unlockedBy("has_silver_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_ingot_from_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.SILVER_NUGGET).unlockedBy("has_silver_nugget", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_NUGGET)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_ingot_from_nuggets"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_NUGGET.get()), (int)9).requires(OccultismTags.Items.SILVER_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_nugget"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.RAW_SILVER_BLOCK.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), OccultismTags.Items.RAW_SILVER).unlockedBy("has_raw_silver", OccultismRecipeProvider.has(OccultismTags.Items.RAW_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_silver_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.RAW_SILVER.get()), (int)9).requires(OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER).unlockedBy("has_raw_silver_block", OccultismRecipeProvider.has(OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/raw_silver_ingot_from_block"));
    }

    private void craftingRecipes(RecipeOutput pRecipeOutput) {
        SpecialRecipeBuilder.special(BoundBookOfBindingRecipe::new).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/bound_book_of_binding"));
        OccultismRecipeProvider.metalRecipes(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get())).requires((ItemLike)OccultismItems.AWAKENED_FEATHER.get()).requires((ItemLike)OccultismItems.PURIFIED_INK.get()).requires((ItemLike)OccultismItems.TABOO_BOOK.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_empty"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).pattern("cpf").pattern("pbp").pattern(" p ").define(Character.valueOf('p'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_afrit"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).pattern(" p ").pattern("pbp").pattern(" p ").define(Character.valueOf('p'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_afrit_from_empty"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).pattern("cgf").pattern("gbg").pattern(" g ").define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('g'), Tags.Items.DYES_PURPLE).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_djinni"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).pattern(" g ").pattern("gbg").pattern(" g ").define(Character.valueOf('g'), Tags.Items.DYES_PURPLE).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_empty_binding", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_djinni_from_empty"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get())).requires(OccultismTags.Items.BOOK_OF_CALLING_DJINNI).unlockedBy("has_book_of_calling_djinni", OccultismRecipeProvider.has(OccultismTags.Items.BOOK_OF_CALLING_DJINNI)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_djinni_from_calling"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).pattern("cwf").pattern("wbw").pattern(" w ").define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('w'), Tags.Items.DYES_BLUE).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_foliot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).pattern(" w ").pattern("wbw").pattern(" w ").define(Character.valueOf('w'), Tags.Items.DYES_BLUE).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_empty_binding", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_foliot_from_empty"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get())).requires(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT).unlockedBy("has_book_of_calling_foliot", OccultismRecipeProvider.has(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_bound_foliot_from_calling"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get())).pattern("cof").pattern("pbp").pattern(" o ").define(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).define(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).define(Character.valueOf('o'), Tags.Items.DYES_GREEN).define(Character.valueOf('p'), Tags.Items.DYES_GREEN).define(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).unlockedBy("has_taboo_book", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_marid"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get())).pattern(" o ").pattern("pbp").pattern(" o ").define(Character.valueOf('o'), Tags.Items.DYES_GREEN).define(Character.valueOf('p'), Tags.Items.DYES_GREEN).define(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).unlockedBy("has_empty_binding", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_binding_marid_from_empty"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()).requires((ItemLike)Items.FURNACE).unlockedBy("has_book_of_binding_bound_djinni", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_djinni_manage_machine"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).requires((ItemLike)OccultismItems.BRUSH.get()).unlockedBy("has_book_of_binding_bound_foliot", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_foliot_cleaner"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).requires(OccultismTags.Items.METAL_AXES).unlockedBy("has_book_of_binding_bound_foliot", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_foliot_lumberjack"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get())).requires((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).requires(Tags.Items.CHESTS).unlockedBy("has_book_of_binding_bound_foliot", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/book_of_calling_foliot_transport_items"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BRUSH.get())).pattern("ppp").pattern("wws").define(Character.valueOf('p'), ItemTags.PLANKS).define(Character.valueOf('w'), ItemTags.WOOL).define(Character.valueOf('s'), Tags.Items.STRINGS).unlockedBy("has_wool", OccultismRecipeProvider.has((TagKey)ItemTags.WOOL)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/brush"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)OccultismItems.BUTCHER_KNIFE.get())).pattern(" is").pattern("is ").pattern("s  ").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_iron_ingot", OccultismRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/butcher_knife"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.TALLOW_BLOCK.get())).requires(Ingredient.of(OccultismTags.Items.TALLOW), 9).unlockedBy("has_tallow", OccultismRecipeProvider.has(OccultismTags.Items.TALLOW)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/tallow_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, OccultismItems.TALLOW, (int)9).requires((ItemLike)OccultismBlocks.TALLOW_BLOCK.get()).unlockedBy("has_tallow_block", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.TALLOW_BLOCK.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/tallow"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get())).pattern("s").pattern("t").define(Character.valueOf('s'), Tags.Items.STRINGS).define(Character.valueOf('t'), OccultismTags.Items.TALLOW).unlockedBy("has_tallow", OccultismRecipeProvider.has(OccultismTags.Items.TALLOW)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_WHITE.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_WHITE).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_white"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_LIGHT_GRAY.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_LIGHT_GRAY).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_light_gray"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_GRAY.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_GRAY).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_gray"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_BLACK.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_BLACK).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_black"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_BROWN.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_BROWN).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_brown"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_RED.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_RED).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_red"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_ORANGE.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_ORANGE).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_orange"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_YELLOW.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_YELLOW).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_yellow"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_LIME.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_LIME).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_lime"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_GREEN.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_GREEN).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_green"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_CYAN.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_CYAN).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_cyan"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_BLUE.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_BLUE).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_blue"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_LIGHT_BLUE.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_LIGHT_BLUE).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_light_blue"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_PINK.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_PINK).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_pink"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_MAGENTA.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_MAGENTA).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_magenta"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE_PURPLE.get())).requires((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).requires(Tags.Items.DYES_PURPLE).unlockedBy("has_large_candle", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.LARGE_CANDLE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/large_candle_purple"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_YELLOW_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(Tags.Items.DUSTS_GLOWSTONE).requires(OccultismTags.Items.GOLD_DUST).requires(OccultismTags.Items.GOLD_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_yellow_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_PURPLE_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.END_STONE_DUST).requires(OccultismTags.Items.OBSIDIAN_DUST).requires(OccultismTags.Items.OBSIDIAN_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_purple_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_RED_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires((ItemLike)OccultismItems.AFRIT_ESSENCE.get()).requires((ItemLike)Items.TORCHFLOWER).requires(Tags.Items.DUSTS_REDSTONE).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_red_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_LIGHT_GRAY_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.SILVER_DUST).requires(OccultismTags.Items.IRON_DUST).requires(OccultismTags.Items.CALCITE_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_light_gray_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_GRAY_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismItems.GRAY_PASTE).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_gray_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_BLACK_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.WITHERITE_DUST).requires(OccultismTags.Items.WITHERITE_DUST).requires(OccultismTags.Items.WITHERITE_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_black_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_BROWN_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismItems.CRUELTY_ESSENCE).requires((ItemLike)Items.COCOA_BEANS).requires((ItemLike)Items.COCOA_BEANS).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_brown_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_ORANGE_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismItems.CURSED_HONEY).requires((ItemLike)Items.GLOW_BERRIES).requires(OccultismTags.Items.BLAZE_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_orange_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_LIME_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.RESEARCH_DUST).requires(OccultismTags.Items.EMERALD_DUST).requires(Tags.Items.SLIME_BALLS).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_lime_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_GREEN_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismItems.NATURE_PASTE).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_green_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_CYAN_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.IESNIUM_DUST).requires(OccultismTags.Items.ECHO_DUST).requires((ItemLike)Items.GLOW_INK_SAC).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_cyan_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_LIGHT_BLUE_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.ICE_DUST).requires(OccultismTags.Items.PACKED_ICE_DUST).requires(OccultismTags.Items.BLUE_ICE_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_light_blue_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_BLUE_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismItems.MARID_ESSENCE).requires(OccultismTags.Items.LAPIS_DUST).requires(OccultismTags.Items.LAPIS_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_blue_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_MAGENTA_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismTags.Items.DRAGONYST_DUST).requires(OccultismTags.Items.AMETHYST_DUST).requires(OccultismTags.Items.AMETHYST_DUST).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_magenta_impure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_PINK_IMPURE.get())).requires((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).requires(OccultismItems.DEMONIC_MEAT).requires(OccultismItems.DEMONIC_MEAT).requires(OccultismItems.DEMONIC_MEAT).unlockedBy("has_chalk_white_impure", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_pink_impure"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get())).pattern("xy").pattern("xy").pattern("xy").define(Character.valueOf('x'), OccultismTags.Items.OTHERSTONE_DUST).define(Character.valueOf('y'), OccultismTags.Items.OTHERWORLD_WOOD_DUST).unlockedBy("has_ashes", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.OTHERWORLD_ASHES.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chalk_white_impure"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get())).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), Ingredient.fromValues(Stream.of(new Ingredient.TagValue(OccultismTags.Items.DATURA_CROP), new Ingredient.TagValue(OccultismTags.Items.DATURA_SEEDS)))).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_CROP)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/demons_dream_essence_from_fruit_or_seed"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get())).requires(OccultismTags.Items.DATURA_SEEDS).requires(OccultismTags.Items.BOOKS).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_SEEDS)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/dictionary_of_spirits"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.DIVINATION_ROD.get())).pattern("xyx").pattern("x x").pattern(" x ").define(Character.valueOf('x'), Tags.Items.RODS_WOODEN).define(Character.valueOf('y'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/divination_rod"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get())).pattern(" l ").pattern("lil").pattern(" f ").define(Character.valueOf('l'), Tags.Items.LEATHERS).define(Character.valueOf('i'), (ItemLike)OccultismItems.INFUSED_LENSES.get()).define(Character.valueOf('f'), (ItemLike)OccultismItems.LENS_FRAME.get()).unlockedBy("has_infused_lenses", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.INFUSED_LENSES.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/goggles"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get())).pattern("ggg").pattern("gbg").pattern("ggg").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('b'), (ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()).unlockedBy("has_sacrificial_bowl", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/golden_sacrificial_bowl"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.IESNIUM_PICKAXE.get())).pattern("iii").pattern(" s ").pattern(" s ").define(Character.valueOf('i'), OccultismTags.Items.IESNIUM_INGOT).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_iesnium_ingot", OccultismRecipeProvider.has(OccultismTags.Items.IESNIUM_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/iesnium_pickaxe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.LENS_FRAME.get())).pattern("ooo").pattern("s s").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).define(Character.valueOf('s'), OccultismTags.Items.SILVER_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/lens_frame"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.LENSES.get())).pattern("ppp").pattern("pgp").pattern("ppp").define(Character.valueOf('p'), Tags.Items.GLASS_PANES).define(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/lenses"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get())).pattern(" s ").pattern("sis").pattern(" ss").define(Character.valueOf('s'), OccultismTags.Items.SILVER_INGOT).define(Character.valueOf('i'), OccultismTags.Items.IESNIUM_INGOT).unlockedBy("has_silver_ingot", OccultismRecipeProvider.has(OccultismTags.Items.SILVER_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/magic_lamp_empty"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.OTHERSTONE_FRAME.get())).pattern("ooo").pattern("o o").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_frame"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get())).pattern("s s").pattern(" o ").pattern("sss").define(Character.valueOf('s'), (ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()).define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_pedestal"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL_SILVER.get())).requires(OccultismTags.Items.SILVER_INGOT).requires((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get()).unlockedBy("has_otherstone_pedestal", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_pedestal_silver"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER0.get())).requires((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get()).unlockedBy("has_otherstone_pedestal", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/storage_stabilizer_tier0"));
        OccultismRecipeProvider.stairBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERSTONE.asItem()})).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERSTONE.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()), (int)6).pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_PRESSURE_PLATE.get())).pattern("oo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_pressure_plate"));
        OccultismRecipeProvider.buttonBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERSTONE.asItem()})).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERSTONE.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_WALL.get()), (int)6).pattern("ooo").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_wall"));
        OccultismRecipeProvider.stairBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERCOBBLESTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERCOBBLESTONE.asItem()})).unlockedBy("has_othercobblestone", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERCOBBLESTONE.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/othercobblestone_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERCOBBLESTONE_SLAB.get()), (int)6).pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERCOBBLESTONE.get()).unlockedBy("has_othercobblestone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERCOBBLESTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/othercobblestone_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERCOBBLESTONE_WALL.get()), (int)6).pattern("ooo").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERCOBBLESTONE.get()).unlockedBy("has_othercobblestone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERCOBBLESTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/othercobblestone_wall"));
        OccultismRecipeProvider.stairBuilder((ItemLike)((ItemLike)OccultismBlocks.POLISHED_OTHERSTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.POLISHED_OTHERSTONE.asItem()})).unlockedBy("has_polished_otherstone", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.POLISHED_OTHERSTONE.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/polished_otherstone_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.POLISHED_OTHERSTONE_SLAB.get()), (int)6).pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.POLISHED_OTHERSTONE.get()).unlockedBy("has_polished_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/polished_otherstone_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.POLISHED_OTHERSTONE_WALL.get()), (int)6).pattern("ooo").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.POLISHED_OTHERSTONE.get()).unlockedBy("has_polished_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.POLISHED_OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/polished_otherstone_wall"));
        OccultismRecipeProvider.stairBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERSTONE_BRICKS.asItem()})).unlockedBy("has_otherstone_bricks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_bricks_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS_SLAB.get()), (int)6).pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE_BRICKS.get()).unlockedBy("has_otherstone_bricks", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_bricks_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS_WALL.get()), (int)6).pattern("ooo").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE_BRICKS.get()).unlockedBy("has_otherstone_bricks", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_bricks_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS.get()), (int)4).pattern("oo").pattern("oo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_bricks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.CHISELED_OTHERSTONE_BRICKS.get())).pattern("o").pattern("o").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE_BRICKS_SLAB.get()).unlockedBy("has_otherstone_bricks_slab", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_BRICKS_SLAB.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/chiseled_otherstone_bricks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.OTHERSTONE_TABLET.get())).pattern("sss").pattern("sss").pattern("sss").define(Character.valueOf('s'), (ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()).unlockedBy("has_otherstone_slab", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherstone_tablet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get())).pattern("o o").pattern("ooo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).unlockedBy("has_otherstone", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/sacrificial_bowl"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.COPPER_SACRIFICIAL_BOWL.get())).requires((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.asItem()).requires(Tags.Items.INGOTS_COPPER).unlockedBy("has_sacrificial_bowl", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/copper_sacrificial_bowl"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.SILVER_SACRIFICIAL_BOWL.get())).requires((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.asItem()).requires(OccultismTags.Items.SILVER_INGOT).unlockedBy("has_sacrificial_bowl", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/silver_sacrificial_bowl"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get())).pattern("gg").pattern("gg").define(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_attuned_crystal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_PICKAXE_HEAD.get())).pattern("ggg").define(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).unlockedBy("has_spirit_attuned_gem", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_attuned_pickaxe_head"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_CAMPFIRE.get())).pattern(" S ").pattern("S#S").pattern("LLL").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('#'), OccultismTags.Items.DATURA_CROP).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_CROP)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_campfire"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_LANTERN.get())).pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('#'), (ItemLike)OccultismBlocks.SPIRIT_TORCH.get()).unlockedBy("has_spirit_torch", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.SPIRIT_TORCH.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_lantern"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_TORCH.get())).pattern("X").pattern("#").pattern("S").define(Character.valueOf('X'), ItemTags.COALS).define(Character.valueOf('#'), OccultismTags.Items.DATURA_CROP).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_datura", OccultismRecipeProvider.has(OccultismTags.Items.DATURA_CROP)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/spirit_torch"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get())).pattern("d").pattern("b").define(Character.valueOf('d'), (ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()).define(Character.valueOf('b'), (ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()).unlockedBy("has_dimensional_matrix", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/storage_controller"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.STORAGE_REMOTE_INERT.get())).pattern("gtg").pattern("bgb").pattern("bbb").define(Character.valueOf('t'), (ItemLike)OccultismItems.OTHERSTONE_TABLET.get()).define(Character.valueOf('b'), ItemTags.STONE_BUTTONS).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).unlockedBy("has_otherstone_tablet", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.OTHERSTONE_TABLET.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/storage_remote_inert"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.WORMHOLE_FRAME.get())).pattern(" g ").pattern("gog").pattern(" g ").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('o'), (ItemLike)OccultismItems.OTHERSTONE_FRAME.get()).unlockedBy("has_otherstone_frame", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.OTHERSTONE_FRAME.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/wormhole_frame"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.OTHERGLASS_NATURAL.get())).pattern("nen").pattern("ege").pattern("nen").define(Character.valueOf('n'), OccultismTags.Items.IESNIUM_NUGGET).define(Character.valueOf('e'), OccultismTags.Items.END_STONE_DUST).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_iesnium_nugget", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismItems.IESNIUM_NUGGET.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherglass"));
    }

    private static void woodRecipes(RecipeOutput pRecipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS.get()), (int)4).requires(OccultismTags.Items.OTHERWORLD_LOGS).unlockedBy("has_otherworld_log", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERWORLD_LOG.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERWORLD_WOOD.get()), (int)3).pattern("oo").pattern("oo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERWORLD_LOG.get()).unlockedBy("has_otherworld_log", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERWORLD_LOG.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherworld_wood"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.STRIPPED_OTHERWORLD_WOOD.get()), (int)3).pattern("oo").pattern("oo").define(Character.valueOf('o'), (ItemLike)OccultismBlocks.STRIPPED_OTHERWORLD_LOG.get()).unlockedBy("has_otherworld_log", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.STRIPPED_OTHERWORLD_LOG.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/stripped_otherworld_wood"));
        OccultismRecipeProvider.stairBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERPLANKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_stairs"));
        OccultismRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_slab"));
        OccultismRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_PRESSURE_PLATE.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_pressure_plate"));
        OccultismRecipeProvider.buttonBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERPLANKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_button"));
        OccultismRecipeProvider.fenceBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_FENCE.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERPLANKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_fence"));
        OccultismRecipeProvider.fenceGateBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_FENCE_GATE.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERPLANKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_fence_gate"));
        OccultismRecipeProvider.doorBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_DOOR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERPLANKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_door"));
        OccultismRecipeProvider.trapdoorBuilder((ItemLike)((ItemLike)OccultismBlocks.OTHERPLANKS_TRAPDOOR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERPLANKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_trapdoor"));
        OccultismRecipeProvider.signBuilder(OccultismItems.OTHERPLANKS_SIGN, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.OTHERPLANKS.asItem()})).unlockedBy("has_otherplanks", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERPLANKS.asItem())).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_sign"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, OccultismItems.OTHERPLANKS_HANGING_SIGN, (int)6).group("hanging_sign").define(Character.valueOf('#'), (ItemLike)OccultismBlocks.STRIPPED_OTHERWORLD_LOG.asItem()).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_otherworld_log", OccultismRecipeProvider.has((ItemLike)((ItemLike)OccultismBlocks.STRIPPED_OTHERWORLD_LOG.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crafting/otherplanks_hanging_sign"));
    }

    private static void smeltingRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.autoSmeltingRecipe(OccultismBlocks.OTHERSTONE.asItem(), OccultismItems.BURNT_OTHERSTONE.asItem(), Float.valueOf(0.15f), pRecipeOutput);
        OccultismRecipeProvider.autoSmeltingRecipe(OccultismBlocks.OTHERCOBBLESTONE.asItem(), OccultismBlocks.POLISHED_OTHERSTONE.asItem(), Float.valueOf(0.5f), pRecipeOutput);
        OccultismRecipeProvider.autoSmeltingRecipe(OccultismBlocks.OTHERSTONE_BRICKS.asItem(), OccultismBlocks.CRACKED_OTHERSTONE_BRICKS.asItem(), Float.valueOf(0.3f), pRecipeOutput);
    }

    protected static void autoSmeltingRecipe(Item input, Item output, Float exp, RecipeOutput pRecipeOutput) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)exp.floatValue(), (int)200).unlockedBy("has_" + input.toString().replace("occultism:", ""), OccultismRecipeProvider.has((ItemLike)input)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("smelting/" + output.toString().replace("occultism:", ""))));
    }

    private static void oresCookingRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.doubleCookingRecipe(OccultismTags.Items.SILVER_ORE, (Item)OccultismItems.SILVER_INGOT.get(), pRecipeOutput);
        OccultismRecipeProvider.doubleCookingRecipe(OccultismTags.Items.RAW_SILVER, (Item)OccultismItems.SILVER_INGOT.get(), pRecipeOutput);
        OccultismRecipeProvider.doubleCookingRecipe(OccultismTags.Items.IESNIUM_ORE, (Item)OccultismItems.IESNIUM_INGOT.get(), pRecipeOutput);
        OccultismRecipeProvider.doubleCookingRecipe(OccultismTags.Items.RAW_IESNIUM, (Item)OccultismItems.IESNIUM_INGOT.get(), pRecipeOutput);
    }

    protected static void doubleCookingRecipe(TagKey<Item> tagInput, Item output, RecipeOutput recipeOutput) {
        String outputString = output.toString().replace("minecraft:", "").replace("occultism:", "");
        String simpleInputString = tagInput.toString().contains("c:ores") ? "ore" : "raw";
        String condtionString = "has_" + tagInput.toString().substring(26).replace("materials/", "").replace("/", "_").replace("]", "");
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(tagInput), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.7f, (int)200).unlockedBy(condtionString, OccultismRecipeProvider.has(tagInput)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("smelting/" + outputString + "_from_" + simpleInputString)));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(tagInput), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.7f, (int)100).unlockedBy(condtionString, OccultismRecipeProvider.has(tagInput)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("blasting/" + outputString + "_from_" + simpleInputString)));
    }

    private static void spiritFireRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_WHITE_IMPURE.asItem(), OccultismItems.CHALK_WHITE.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_LIGHT_GRAY_IMPURE.asItem(), OccultismItems.CHALK_LIGHT_GRAY.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_GRAY_IMPURE.asItem(), OccultismItems.CHALK_GRAY.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_BLACK_IMPURE.asItem(), OccultismItems.CHALK_BLACK.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_YELLOW_IMPURE.asItem(), OccultismItems.CHALK_YELLOW.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_PURPLE_IMPURE.asItem(), OccultismItems.CHALK_PURPLE.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_LIME_IMPURE.asItem(), OccultismItems.CHALK_LIME.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_ORANGE_IMPURE.asItem(), OccultismItems.CHALK_ORANGE.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_RED_IMPURE.asItem(), OccultismItems.CHALK_RED.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_BLUE_IMPURE.asItem(), OccultismItems.CHALK_BLUE.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_GREEN_IMPURE.asItem(), OccultismItems.CHALK_GREEN.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_LIGHT_BLUE_IMPURE.asItem(), OccultismItems.CHALK_LIGHT_BLUE.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_PINK_IMPURE.asItem(), OccultismItems.CHALK_PINK.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_CYAN_IMPURE.asItem(), OccultismItems.CHALK_CYAN.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_BROWN_IMPURE.asItem(), OccultismItems.CHALK_BROWN.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.CHALK_MAGENTA_IMPURE.asItem(), OccultismItems.CHALK_MAGENTA.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismItems.DEMONS_DREAM_ESSENCE.asItem(), OccultismItems.OTHERWORLD_ESSENCE.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(Items.OAK_SAPLING, OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(Items.ANDESITE, OccultismBlocks.OTHERSTONE.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute((TagKey<Item>)Tags.Items.GEMS_DIAMOND, OccultismItems.SPIRIT_ATTUNED_GEM.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismTags.Items.OTHERWORLD_LOGS, OccultismItems.OTHERWORLD_ASHES.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute((TagKey<Item>)Tags.Items.FEATHERS, OccultismItems.AWAKENED_FEATHER.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute((TagKey<Item>)Tags.Items.DYES_BLACK, OccultismItems.PURIFIED_INK.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(Items.BOOK, OccultismItems.TABOO_BOOK.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute(OccultismTags.Items.BOOKS_FOR_EMPTY, OccultismItems.BOOK_OF_BINDING_EMPTY.asItem(), pRecipeOutput);
        OccultismRecipeProvider.spiritfireTransmute((TagKey<Item>)ItemTags.FLOWERS, OccultismBlocks.OTHERFLOWER.asItem(), pRecipeOutput);
    }

    protected static void spiritfireTransmute(TagKey<Item> input, Item output, RecipeOutput pRecipeOutput) {
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of(input), new ItemStack((ItemLike)output)).unlockedBy("has_tag_item", OccultismRecipeProvider.has(input)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("spirit_fire/" + output.toString().replace("occultism:", ""))));
    }

    protected static void spiritfireTransmute(Item input, Item output, RecipeOutput pRecipeOutput) {
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.of((ItemLike[])new ItemLike[]{input}), new ItemStack((ItemLike)output)).unlockedBy("has_" + input.toString().replace("minecraft:", "").replace("occultism:", ""), OccultismRecipeProvider.has((ItemLike)input)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("spirit_fire/" + output.toString().replace("occultism:", ""))));
    }

    private static void stonecutterRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_SLAB, OccultismBlocks.OTHERSTONE, 2);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_STAIRS, OccultismBlocks.OTHERSTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_WALL, OccultismBlocks.OTHERSTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_BRICKS, OccultismBlocks.OTHERSTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_BRICKS_SLAB, OccultismBlocks.OTHERSTONE, 2);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_BRICKS_STAIRS, OccultismBlocks.OTHERSTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_BRICKS_WALL, OccultismBlocks.OTHERSTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERCOBBLESTONE_SLAB, OccultismBlocks.OTHERCOBBLESTONE, 2);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERCOBBLESTONE_STAIRS, OccultismBlocks.OTHERCOBBLESTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERCOBBLESTONE_WALL, OccultismBlocks.OTHERCOBBLESTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.POLISHED_OTHERSTONE_SLAB, OccultismBlocks.POLISHED_OTHERSTONE, 2);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.POLISHED_OTHERSTONE_STAIRS, OccultismBlocks.POLISHED_OTHERSTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.POLISHED_OTHERSTONE_WALL, OccultismBlocks.POLISHED_OTHERSTONE);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_BRICKS_SLAB, OccultismBlocks.OTHERSTONE_BRICKS, 2);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_BRICKS_STAIRS, OccultismBlocks.OTHERSTONE_BRICKS);
        OccultismRecipeProvider.otherStonecutter(pRecipeOutput, OccultismBlocks.OTHERSTONE_BRICKS_WALL, OccultismBlocks.OTHERSTONE_BRICKS);
    }

    protected static void otherStonecutter(RecipeOutput recipeOutput, ItemLike result, ItemLike material, int resultCount) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)resultCount).unlockedBy(OccultismRecipeProvider.getHasName((ItemLike)material), OccultismRecipeProvider.has((ItemLike)material)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("stonecutting/" + OccultismRecipeProvider.getItemName((ItemLike)result) + "_from_" + OccultismRecipeProvider.getItemName((ItemLike)material))));
    }

    protected static void otherStonecutter(RecipeOutput recipeOutput, ItemLike result, ItemLike material) {
        OccultismRecipeProvider.otherStonecutter(recipeOutput, result, material, 1);
    }

    private static void otherflowerRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.WHITE_DYE, (TagKey<Item>)Tags.Items.DYES_WHITE, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.LIGHT_GRAY_DYE, (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.GRAY_DYE, (TagKey<Item>)Tags.Items.DYES_GRAY, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.BLACK_DYE, (TagKey<Item>)Tags.Items.DYES_BLACK, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.BROWN_DYE, (TagKey<Item>)Tags.Items.DYES_BROWN, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.RED_DYE, (TagKey<Item>)Tags.Items.DYES_RED, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.ORANGE_DYE, (TagKey<Item>)Tags.Items.DYES_ORANGE, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.YELLOW_DYE, (TagKey<Item>)Tags.Items.DYES_YELLOW, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.LIME_DYE, (TagKey<Item>)Tags.Items.DYES_LIME, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.GREEN_DYE, (TagKey<Item>)Tags.Items.DYES_GREEN, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.CYAN_DYE, (TagKey<Item>)Tags.Items.DYES_CYAN, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.BLUE_DYE, (TagKey<Item>)Tags.Items.DYES_BLUE, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.LIGHT_BLUE_DYE, (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.PINK_DYE, (TagKey<Item>)Tags.Items.DYES_PINK, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.MAGENTA_DYE, (TagKey<Item>)Tags.Items.DYES_MAGENTA, pRecipeOutput);
        OccultismRecipeProvider.otherflowerDye((ItemLike)Items.PURPLE_DYE, (TagKey<Item>)Tags.Items.DYES_PURPLE, pRecipeOutput);
    }

    protected static void otherflowerDye(ItemLike result, TagKey<Item> colorTag, RecipeOutput pRecipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)3).requires((ItemLike)OccultismBlocks.OTHERFLOWER.asItem()).requires(colorTag).unlockedBy("has_otherflower", OccultismRecipeProvider.has((ItemLike)OccultismBlocks.OTHERFLOWER.asItem())).save(pRecipeOutput, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crafting/otherflower_to_" + colorTag.toString().substring(31).replace("]", "_")))) + "dye");
    }

    private static void grayPasteRecipes(RecipeOutput pRecipeOutput) {
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.ECHO_DUST, Items.ECHO_SHARD, RecipeCategory.MISC, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.LAPIS_DUST, Items.LAPIS_LAZULI, RecipeCategory.MISC, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.AMETHYST_DUST, Items.AMETHYST_SHARD, RecipeCategory.MISC, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.EMERALD_DUST, Items.EMERALD, RecipeCategory.MISC, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.ICE_DUST, Items.ICE, RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.PACKED_ICE_DUST, Items.PACKED_ICE, RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.BLUE_ICE_DUST, Items.BLUE_ICE, RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.END_STONE_DUST, Items.END_STONE, RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.OBSIDIAN_DUST, Items.OBSIDIAN, RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.CALCITE_DUST, Items.CALCITE, RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.BLACKSTONE_DUST, Items.BLACKSTONE, RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
        OccultismRecipeProvider.grayPasting(OccultismTags.Items.OTHERSTONE_DUST, OccultismBlocks.OTHERSTONE.asItem(), RecipeCategory.BUILDING_BLOCKS, pRecipeOutput);
    }

    protected static void grayPasting(TagKey<Item> input, Item output, RecipeCategory category, RecipeOutput pRecipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)output).requires(OccultismItems.GRAY_PASTE).requires(input).unlockedBy("has_gray_paste", OccultismRecipeProvider.has(OccultismItems.GRAY_PASTE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crafting/gray_paste/" + output.toString().replace("minecraft:", "").replace("occultism:", ""))));
    }
}

