/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.advancement.RitualTrigger;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRituals;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class OccultismAdvancementSubProvider
implements AdvancementProvider.AdvancementGenerator {
    protected Consumer<AdvancementHolder> saver;
    protected HolderLookup.Provider registries;
    protected ExistingFileHelper existingFileHelper;

    private static MutableComponent text(String name, String type) {
        return Component.translatable((String)("advancements.occultism." + name + "." + type));
    }

    public static MutableComponent title(String name) {
        return OccultismAdvancementSubProvider.text(name, "title");
    }

    public static MutableComponent descr(String name) {
        return OccultismAdvancementSubProvider.text(name, "description");
    }

    private static MutableComponent familiarText(String name, String type) {
        return Component.translatable((String)("advancements.occultism.familiar." + name + "." + type));
    }

    public static MutableComponent familiarTitle(String name) {
        return OccultismAdvancementSubProvider.familiarText(name, "title");
    }

    public static MutableComponent familiarDescr(String name) {
        return OccultismAdvancementSubProvider.familiarText(name, "description");
    }

    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        this.registries = registries;
        this.saver = saver;
        this.existingFileHelper = existingFileHelper;
        this.start();
    }

    private void start() {
        AdvancementHolder root = this.add(Advancement.Builder.advancement().addCriterion("occultism_present", PlayerTrigger.TriggerInstance.tick()).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/root")));
        AdvancementHolder familiarsRoot = this.add(Advancement.Builder.advancement().display((ItemLike)OccultismItems.PENTACLE_POSSESS.get(), (Component)OccultismAdvancementSubProvider.title("familiars"), (Component)OccultismAdvancementSubProvider.descr("familiars"), ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/block/otherplanks.png"), AdvancementType.TASK, true, true, false).addCriterion("summon_familiar", RitualTrigger.TriggerInstance.ritualFactory(OccultismRituals.FAMILIAR.getId())).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/root")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(2), (Component)OccultismAdvancementSubProvider.familiarTitle("deer"), (Component)OccultismAdvancementSubProvider.familiarDescr("deer"), null, AdvancementType.TASK, true, true, false).addCriterion("deer_poop", FamiliarTrigger.of(FamiliarTrigger.Type.DEER_POOP)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/deer")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(0), (Component)OccultismAdvancementSubProvider.familiarTitle("cthulhu"), (Component)OccultismAdvancementSubProvider.familiarDescr("cthulhu"), null, AdvancementType.TASK, true, true, false).addCriterion("cthulhu_sad", FamiliarTrigger.of(FamiliarTrigger.Type.CTHULHU_SAD)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/cthulhu")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(1), (Component)OccultismAdvancementSubProvider.familiarTitle("bat"), (Component)OccultismAdvancementSubProvider.familiarDescr("bat"), null, AdvancementType.TASK, true, true, false).addCriterion("bat_eat", FamiliarTrigger.of(FamiliarTrigger.Type.BAT_EAT)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/bat")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(3), (Component)OccultismAdvancementSubProvider.familiarTitle("devil"), (Component)OccultismAdvancementSubProvider.familiarDescr("devil"), null, AdvancementType.TASK, true, true, false).addCriterion("devil_fire", FamiliarTrigger.of(FamiliarTrigger.Type.DEVIL_FIRE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/devil")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(4), (Component)OccultismAdvancementSubProvider.familiarTitle("greedy"), (Component)OccultismAdvancementSubProvider.familiarDescr("greedy"), null, AdvancementType.TASK, true, true, false).addCriterion("greedy_item", FamiliarTrigger.of(FamiliarTrigger.Type.GREEDY_ITEM)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/greedy")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(5), (Component)OccultismAdvancementSubProvider.familiarTitle("rare"), (Component)OccultismAdvancementSubProvider.familiarDescr("rare"), null, AdvancementType.TASK, true, true, false).addCriterion("rare_variant", FamiliarTrigger.of(FamiliarTrigger.Type.RARE_VARIANT)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/rare")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display((ItemLike)Items.JUKEBOX, (Component)OccultismAdvancementSubProvider.familiarTitle("party"), (Component)OccultismAdvancementSubProvider.familiarDescr("party"), null, AdvancementType.TASK, true, true, false).addCriterion("party", FamiliarTrigger.of(FamiliarTrigger.Type.PARTY)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/party")));
        ItemStack familiarRingStack = new ItemStack((ItemLike)OccultismItems.FAMILIAR_RING.get());
        familiarRingStack.set(OccultismDataComponents.SPIRIT_NAME, (Object)"Gardelldor");
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(new DisplayInfo(familiarRingStack, (Component)OccultismAdvancementSubProvider.familiarTitle("capture"), (Component)OccultismAdvancementSubProvider.familiarDescr("capture"), Optional.ofNullable(null), AdvancementType.TASK, true, true, false)).addCriterion("capture", FamiliarTrigger.of(FamiliarTrigger.Type.CAPTURE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/capture")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display((ItemLike)Items.GOLD_NUGGET, (Component)OccultismAdvancementSubProvider.familiarTitle("dragon_nugget"), (Component)OccultismAdvancementSubProvider.familiarDescr("dragon_nugget"), null, AdvancementType.TASK, true, true, false).addCriterion("dragon_nugget", FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_NUGGET)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/dragon_nugget")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(6), (Component)OccultismAdvancementSubProvider.familiarTitle("dragon_ride"), (Component)OccultismAdvancementSubProvider.familiarDescr("dragon_ride"), null, AdvancementType.TASK, true, true, false).addCriterion("dragon_ride", FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_RIDE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/dragon_ride")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display((ItemLike)Items.STICK, (Component)OccultismAdvancementSubProvider.familiarTitle("mans_best_friend"), (Component)OccultismAdvancementSubProvider.familiarDescr("mans_best_friend"), null, AdvancementType.TASK, true, true, false).addCriterion("dragon_pet", FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_PET)).addCriterion("dragon_fetch", FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_FETCH)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/mans_best_friend")));
        this.add(Advancement.Builder.advancement().parent(root).display(this.icon(7), (Component)OccultismAdvancementSubProvider.familiarTitle("blacksmith_upgrade"), (Component)OccultismAdvancementSubProvider.familiarDescr("blacksmith_upgrade"), null, AdvancementType.TASK, true, true, false).addCriterion("blacksmith_upgrade", FamiliarTrigger.of(FamiliarTrigger.Type.BLACKSMITH_UPGRADE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/blacksmith_upgrade")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(8), (Component)OccultismAdvancementSubProvider.familiarTitle("guardian_ultimate_sacrifice"), (Component)OccultismAdvancementSubProvider.familiarDescr("guardian_ultimate_sacrifice"), null, AdvancementType.TASK, true, true, false).addCriterion("guardian_ultimate_sacrifice", FamiliarTrigger.of(FamiliarTrigger.Type.GUARDIAN_ULTIMATE_SACRIFICE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/guardian_ultimate_sacrifice")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(9), (Component)OccultismAdvancementSubProvider.familiarTitle("headless_cthulhu_head"), (Component)OccultismAdvancementSubProvider.familiarDescr("headless_cthulhu_head"), null, AdvancementType.TASK, true, true, false).addCriterion("headless_cthulhu_head", FamiliarTrigger.of(FamiliarTrigger.Type.HEADLESS_CTHULHU_HEAD)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/headless_cthulhu_head")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display((ItemLike)Items.HAY_BLOCK, (Component)OccultismAdvancementSubProvider.familiarTitle("headless_rebuilt"), (Component)OccultismAdvancementSubProvider.familiarDescr("headless_rebuilt"), null, AdvancementType.TASK, true, true, false).addCriterion("headless_rebuilt", FamiliarTrigger.of(FamiliarTrigger.Type.HEADLESS_REBUILT)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/headless_rebuilt")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(10), (Component)OccultismAdvancementSubProvider.familiarTitle("chimera_ride"), (Component)OccultismAdvancementSubProvider.familiarDescr("chimera_ride"), null, AdvancementType.TASK, true, true, false).addCriterion("chimera_ride", FamiliarTrigger.of(FamiliarTrigger.Type.CHIMERA_RIDE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/chimera_ride")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display((ItemLike)Items.GOLDEN_APPLE, (Component)OccultismAdvancementSubProvider.familiarTitle("goat_detach"), (Component)OccultismAdvancementSubProvider.familiarDescr("goat_detach"), null, AdvancementType.TASK, true, true, false).addCriterion("goat_detach", FamiliarTrigger.of(FamiliarTrigger.Type.GOAT_DETACH)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/goat_detach")));
        AdvancementHolder summonShub = this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(11), (Component)OccultismAdvancementSubProvider.familiarTitle("shub_niggurath_summon"), (Component)OccultismAdvancementSubProvider.familiarDescr("shub_niggurath_summon"), null, AdvancementType.TASK, true, true, false).addCriterion("shub_niggurath_summon", FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_NIGGURATH_SUMMON)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/shub_niggurath_summon")));
        this.add(Advancement.Builder.advancement().parent(summonShub).display((ItemLike)Items.POPPY, (Component)OccultismAdvancementSubProvider.familiarTitle("shub_cthulhu_friends"), (Component)OccultismAdvancementSubProvider.familiarDescr("shub_cthulhu_friends"), null, AdvancementType.TASK, true, true, false).addCriterion("shub_cthulhu_friends", FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_CTHULHU_FRIENDS)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/shub_cthulhu_friends")));
        this.add(Advancement.Builder.advancement().parent(summonShub).display(this.icon(12), (Component)OccultismAdvancementSubProvider.familiarTitle("shub_niggurath_spawn"), (Component)OccultismAdvancementSubProvider.familiarDescr("shub_niggurath_spawn"), null, AdvancementType.TASK, true, true, false).addCriterion("shub_niggurath_spawn", FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_NIGGURATH_SPAWN)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/shub_niggurath_spawn")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(13), (Component)OccultismAdvancementSubProvider.familiarTitle("beholder_ray"), (Component)OccultismAdvancementSubProvider.familiarDescr("beholder_ray"), null, AdvancementType.TASK, true, true, false).addCriterion("beholder_ray", FamiliarTrigger.of(FamiliarTrigger.Type.BEHOLDER_RAY)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/beholder_ray")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display((ItemLike)Items.PUMPKIN_PIE, (Component)OccultismAdvancementSubProvider.familiarTitle("beholder_eat"), (Component)OccultismAdvancementSubProvider.familiarDescr("beholder_eat"), null, AdvancementType.TASK, true, true, false).addCriterion("beholder_eat", FamiliarTrigger.of(FamiliarTrigger.Type.BEHOLDER_EAT)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/beholder_eat")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(14), (Component)OccultismAdvancementSubProvider.familiarTitle("fairy_save"), (Component)OccultismAdvancementSubProvider.familiarDescr("fairy_save"), null, AdvancementType.TASK, true, true, false).addCriterion("fairy_save", FamiliarTrigger.of(FamiliarTrigger.Type.FAIRY_SAVE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/fairy_save")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(15), (Component)OccultismAdvancementSubProvider.familiarTitle("mummy_dodge"), (Component)OccultismAdvancementSubProvider.familiarDescr("mummy_dodge"), null, AdvancementType.TASK, true, true, false).addCriterion("mummy_dodge", FamiliarTrigger.of(FamiliarTrigger.Type.MUMMY_DODGE)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/mummy_dodge")));
        this.add(Advancement.Builder.advancement().parent(familiarsRoot).display(this.icon(16), (Component)OccultismAdvancementSubProvider.familiarTitle("beaver_woodchop"), (Component)OccultismAdvancementSubProvider.familiarDescr("beaver_woodchop"), null, AdvancementType.TASK, true, true, false).addCriterion("beaver_woodchop", FamiliarTrigger.of(FamiliarTrigger.Type.BEAVER_WOODCHOP)).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"occultism/familiar/beaver_woodchop")));
        BuiltInRegistries.ITEM.forEach(item -> {
            ResourceLocation key = BuiltInRegistries.ITEM.getKey(item);
            if (key.getPath().startsWith("ritual_dummy/") && !key.getPath().startsWith("ritual_dummy/custom")) {
                this.addRitualHidden(root, key.getPath().substring(13));
            }
        });
    }

    private AdvancementHolder addRitualHidden(AdvancementHolder parent, String id) {
        return this.add(Advancement.Builder.advancement().parent(parent).display((ItemLike)OccultismItems.JEI_DUMMY_NONE.get(), (Component)OccultismAdvancementSubProvider.title(id), (Component)OccultismAdvancementSubProvider.descr(id), null, AdvancementType.TASK, false, false, true).addCriterion(id, ((RitualTrigger)((Object)OccultismAdvancements.RITUAL.get())).createCriterion((CriterionTriggerInstance)new RitualTrigger.TriggerInstance(Optional.empty(), Optional.of(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("ritual/" + id))), Optional.empty()))).build(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("occultism/" + id))));
    }

    private AdvancementHolder add(AdvancementHolder advancement) {
        this.saver.accept(advancement);
        return advancement;
    }

    private ItemStack icon(int data) {
        ItemStack icon = ((Item)OccultismItems.ADVANCEMENT_ICON.get()).getDefaultInstance();
        icon.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(data));
        return icon;
    }
}

