/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.common.entity.possessed.horde.PossessedWeakBreezeEntity;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public class WildZombieEntity
extends Zombie {
    protected Optional<PossessedWeakBreezeEntity> master = Optional.empty();

    public WildZombieEntity(EntityType<? extends Zombie> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ARMOR, 5.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25);
    }

    public void setMaster(PossessedWeakBreezeEntity master) {
        this.master = Optional.ofNullable(master);
    }

    public void remove(Entity.RemovalReason reason) {
        this.master.ifPresent(boss -> boss.notifyMinionDeath(this));
        super.remove(reason);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        TagKey<EntityType<?>> wildTrialTag = OccultismTags.Entities.WILD_TRIAL;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildTrialTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildTrialTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    protected boolean isSunBurnTick() {
        return false;
    }
}

