/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SpiritFireBlock
extends BaseFireBlock {
    public static final MapCodec<SpiritFireBlock> CODEC = SpiritFireBlock.simpleCodec(SpiritFireBlock::new);

    public SpiritFireBlock(BlockBehaviour.Properties properties) {
        super(properties, 0.0f);
    }

    protected MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.defaultBlockState();
    }

    protected boolean canBurn(BlockState pState) {
        return true;
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)pEntity;
            SingleRecipeInput recipeInput = new SingleRecipeInput(item.getItem());
            Optional recipe = pLevel.getRecipeManager().getRecipeFor((RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get(), (RecipeInput)recipeInput, pLevel);
            if (recipe.isPresent() && !item.isRemoved()) {
                item.remove(Entity.RemovalReason.DISCARDED);
                ItemStack result = ((SpiritFireRecipe)((RecipeHolder)recipe.get()).value()).assemble(recipeInput, (HolderLookup.Provider)pLevel.registryAccess());
                Vec3 center = Math3DUtil.center(pPos);
                Containers.dropItemStack((Level)pLevel, (double)center.x, (double)(center.y + 0.5), (double)center.z, (ItemStack)result);
                pLevel.playSound(null, pPos, OccultismSounds.START_RITUAL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? this.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos below = pos.below();
        return worldIn.getBlockState(below).isFaceSturdy((BlockGetter)worldIn, pos, Direction.UP);
    }
}

