/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.GuardianFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.GuardianFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;
import software.bernie.geckolib.util.Color;

public class GuardianFamiliarRenderer
extends MobRenderer<GuardianFamiliarEntity, GuardianFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/guardian_familiar.png");

    public GuardianFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GuardianFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_GUARDIAN)), 0.3f);
        this.addLayer(new GuardianFamiliarOverlay((RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel>)this, context));
        this.addLayer(new ToolsLayer((RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel>)this));
        this.addLayer(new GuardianFamiliarTree((RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel>)this));
    }

    public void render(GuardianFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack ppMatrixStackStack, MultiBufferSource pBuffer, int pPackedLight) {
        boolean noLegs;
        ppMatrixStackStack.pushPose();
        boolean bl = noLegs = pEntity.getLives() <= 2;
        ppMatrixStackStack.translate(0.0, pEntity.isSitting() ? (noLegs ? -0.5 : -0.36) : (double)pEntity.getAnimationHeight(pPartialTicks) * 0.08, 0.0);
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, ppMatrixStackStack, pBuffer, pPackedLight);
        ppMatrixStackStack.popPose();
    }

    public ResourceLocation getTextureLocation(GuardianFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class GuardianFamiliarOverlay
    extends RenderLayer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/guardian_familiar_overlay.png");
        private final GuardianFamiliarModel model;

        public GuardianFamiliarOverlay(RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel> parent, EntityRendererProvider.Context context) {
            super(parent);
            this.model = new GuardianFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_GUARDIAN));
        }

        public void render(PoseStack ppMatrixStackStack, MultiBufferSource pBuffer, int pPackedLight, GuardianFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!pLivingEntity.isInvisible()) {
                ((GuardianFamiliarModel)this.getParentModel()).copyPropertiesTo(this.model);
                this.model.prepareMobModel((Entity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
                this.model.setupAnim(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                VertexConsumer ivertexbuilder = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)OVERLAY));
                this.model.renderToBuffer(ppMatrixStackStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)pLivingEntity, (float)0.0f), Color.ofRGBA((float)pLivingEntity.getRed(), (float)pLivingEntity.getGreen(), (float)pLivingEntity.getBlue(), (float)((Mth.cos((float)(pAgeInTicks / 20.0f)) + 1.0f) * 0.3f + 0.4f)).getColor());
            }
        }
    }

    private static class ToolsLayer
    extends RenderLayer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        public ToolsLayer(RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, GuardianFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isInvisible() || !pLivingEntity.hasTools()) {
                return;
            }
            ItemInHandRenderer itemRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            GuardianFamiliarModel model = (GuardianFamiliarModel)this.getParentModel();
            pMatrixStack.pushPose();
            model.body.translateAndRotate(pMatrixStack);
            pMatrixStack.translate(-0.15, -0.25, -0.25);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, -1.0471976f, 0.0f));
            itemRenderer.renderItem((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.STONE_SWORD), ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.popPose();
            pMatrixStack.pushPose();
            model.body.translateAndRotate(pMatrixStack);
            pMatrixStack.translate(-0.15, 0.1, 0.37);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 1.0471976f, -1.9198622f));
            itemRenderer.renderItem((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.STONE_AXE), ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.popPose();
            if (model.leftArm1.visible) {
                pMatrixStack.pushPose();
                model.body.translateAndRotate(pMatrixStack);
                model.leftArm1.translateAndRotate(pMatrixStack);
                pMatrixStack.translate(0.21, 0.2, 0.0);
                pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.0f, 3.6651914f));
                itemRenderer.renderItem((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.STONE_PICKAXE), ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.popPose();
            }
        }
    }

    private static class GuardianFamiliarTree
    extends RenderLayer<GuardianFamiliarEntity, GuardianFamiliarModel> {
        private static final ResourceLocation TREE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/guardian_familiar_tree.png");
        private static final ResourceLocation CHRISTMAS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/guardian_familiar_christmas.png");

        public GuardianFamiliarTree(RenderLayerParent<GuardianFamiliarEntity, GuardianFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GuardianFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isInvisible()) {
                return;
            }
            boolean isChristmas = FamiliarUtil.isChristmas();
            boolean hasTree = entitylivingbaseIn.hasTree();
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)(isChristmas ? CHRISTMAS : TREE)));
            GuardianFamiliarModel model = (GuardianFamiliarModel)this.getParentModel();
            model.tree1.visible = isChristmas || hasTree;
            model.tree2.visible = isChristmas || hasTree;
            model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
        }
    }
}

