/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.blockentity;

import com.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@Deprecated
public class StorageControllerRenderer
implements BlockEntityRenderer<StorageControllerBlockEntity> {
    protected Minecraft minecraft = Minecraft.getInstance();
    protected ItemStack stack;

    public StorageControllerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StorageControllerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (this.stack == null) {
            this.stack = new ItemStack((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get());
        }
        poseStack.pushPose();
        long systemTime = System.currentTimeMillis();
        double systemTimeRadSin8 = Math.sin(Math.toRadians((float)systemTime / 8.0f));
        double systemTimeRadSin16 = Math.sin(Math.toRadians((float)systemTime / 16.0f));
        double offset = systemTimeRadSin16 / 16.0;
        poseStack.translate(0.5, 1.75 + offset, 0.5);
        float angle = systemTime / 16L % 360L;
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        float scale = (float)(1.0 + systemTimeRadSin8 * (double)0.025f);
        poseStack.scale(scale, scale, scale);
        long colorScale = 100L - Math.abs(systemTime / 16L / 2L % 160L - 80L);
        float saturation = (float)systemTimeRadSin8 * 0.5f + 0.5f;
        int color = Color.getHSBColor(0.01f * (float)colorScale, saturation, 0.01f * (float)colorScale).getRGB();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = itemRenderer.getModel(this.stack, blockEntity.getLevel(), null, 0);
        poseStack.translate(-0.5, -0.5, -0.5);
        RenderType rendertype = ItemBlockRenderTypes.getRenderType((ItemStack)this.stack, (boolean)false);
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)this.stack.hasFoil());
        RandomSource random = RandomSource.create();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.renderQuads(poseStack, ivertexbuilder, model.getQuads(null, direction, random), color, combinedLight, combinedOverlay);
        }
        random.setSeed(42L);
        this.renderQuads(poseStack, ivertexbuilder, model.getQuads(null, null, random), color, combinedLight, combinedOverlay);
        poseStack.popPose();
    }

    public void renderQuads(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn, int colorIn, int combinedLightIn, int combinedOverlayIn) {
        PoseStack.Pose pose = matrixStackIn.last();
        for (BakedQuad bakedquad : quadsIn) {
            int i = colorIn;
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            bufferIn.putBulkData(pose, bakedquad, f, f1, f2, 1.0f, combinedLightIn, combinedOverlayIn, true);
        }
    }
}

