/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.api.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.StringJoiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class GlobalBlockPos
implements INBTSerializable<CompoundTag> {
    protected BlockPos pos;
    protected ResourceKey<Level> dimensionKey;
    public static final Codec<GlobalBlockPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(GlobalBlockPos::getPos), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(GlobalBlockPos::getDimensionKey)).apply((Applicative)instance, GlobalBlockPos::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GlobalBlockPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, GlobalBlockPos::getPos, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), GlobalBlockPos::getDimensionKey, GlobalBlockPos::new);

    public GlobalBlockPos() {
    }

    public GlobalBlockPos(BlockPos pos, ResourceKey<Level> dimensionKey) {
        this.pos = pos;
        this.dimensionKey = dimensionKey;
    }

    public GlobalBlockPos(BlockPos pos, Level level) {
        this.pos = pos;
        this.dimensionKey = level.dimension();
    }

    public static GlobalBlockPos from(BlockEntity blockEntity) {
        return new GlobalBlockPos(blockEntity.getBlockPos(), blockEntity.getLevel());
    }

    public static GlobalBlockPos from(HolderLookup.Provider provider, CompoundTag tag) {
        return (GlobalBlockPos)((Pair)CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow()).getFirst();
    }

    public static GlobalBlockPos from(RegistryFriendlyByteBuf buf) {
        return (GlobalBlockPos)STREAM_CODEC.decode((Object)buf);
    }

    public ResourceKey<Level> getDimensionKey() {
        return this.dimensionKey;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int hashCode() {
        return Objects.hash(this.dimensionKey, this.pos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalBlockPos other = (GlobalBlockPos)obj;
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        return this.dimensionKey.equals(other.dimensionKey);
    }

    public String toString() {
        return new StringJoiner(", ", "[", "]").add(this.dimensionKey.registry().toString()).add("x=" + this.pos.getX()).add("y=" + this.pos.getY()).add("z=" + this.pos.getZ()).toString();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeResourceLocation(this.dimensionKey.location());
    }

    public void decode(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation());
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return (CompoundTag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).ifSuccess(p -> {
            this.pos = ((GlobalBlockPos)p.getFirst()).getPos();
            this.dimensionKey = ((GlobalBlockPos)p.getFirst()).getDimensionKey();
        });
    }
}

