/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.util;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.common.item.RestrainingOrder;
import cy.jdkdigital.utilitarian.integration.CuriosIntegration;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModList;

public class Helper {
    public static int locateNearbyNoSoliciting(ServerLevel level, BlockPos spawnPosition) {
        PoiManager poiManager = level.getPoiManager();
        Stream stream = poiManager.getInRange(poi -> poi.is(NoSolicitingModule.NO_SOLICITING_POI_TAG), spawnPosition, (Integer)Config.NO_SOLICITING_BANNER_CHUNK_RANGE.get() * 16, PoiManager.Occupancy.ANY);
        List<BlockPos> posList = stream.map(PoiRecord::getPos).filter(blockPos -> level.getBlockState(blockPos).is((Block)NoSolicitingModule.NO_SOLICITING_BANNER.get()) || level.getBlockState(blockPos).is((Block)NoSolicitingModule.NO_SOLICITING_WALL_BANNER.get())).toList();
        if (!posList.isEmpty()) {
            return posList.size();
        }
        double range = (double)((Integer)Config.NO_SOLICITING_BANNER_CHUNK_RANGE.get()).intValue() * 16.0;
        List<Player> players = level.getEntitiesOfClass(Player.class, new AABB(new BlockPos((Vec3i)spawnPosition)).inflate(range, range, range)).stream().filter(player -> {
            for (ItemStack itemStack : player.getInventory().items) {
                if (!itemStack.is(NoSolicitingModule.RESTRAINING_ORDER) || !RestrainingOrder.isEnabledRestrainingOrder(itemStack)) continue;
                return true;
            }
            if (ModList.get().isLoaded("curios")) {
                return CuriosIntegration.hasRestrainingOrder(player);
            }
            return false;
        }).toList();
        return players.size();
    }

    public static List<BlockPos> locateNearbySoliciting(ServerLevel level, BlockPos spawnPosition) {
        PoiManager poiManager = level.getPoiManager();
        Stream stream = poiManager.getInRange(poi -> poi.is(NoSolicitingModule.SOLICITING_POI_TAG), spawnPosition, (Integer)Config.SOLICITING_CARPET_CHUNK_RANGE.get() * 16, PoiManager.Occupancy.ANY);
        return stream.map(PoiRecord::getPos).sorted(Comparator.comparingDouble(vec -> vec.distSqr((Vec3i)spawnPosition))).toList();
    }

    public static List<BlockPos> locateNearbySoundMuffler(ServerLevel level, BlockPos spawnPosition, TagKey<PoiType> poiTag) {
        PoiManager poiManager = level.getPoiManager();
        Stream stream = poiManager.getInRange(poi -> poi.is(poiTag), spawnPosition, ((Integer)Config.SOUND_MUFFLER_BLOCK_RANGE.get()).intValue(), PoiManager.Occupancy.ANY);
        return stream.map(PoiRecord::getPos).sorted(Comparator.comparingDouble(vec -> vec.distSqr((Vec3i)spawnPosition))).toList();
    }

    public static List<BlockPos> locateNearbyNoRaider(ServerLevel level, BlockPos spawnPosition) {
        PoiManager poiManager = level.getPoiManager();
        Stream stream = poiManager.getInRange(poi -> poi.is(NoSolicitingModule.NO_RAIDER_POI), spawnPosition, 200, PoiManager.Occupancy.ANY);
        return stream.map(PoiRecord::getPos).sorted(Comparator.comparingDouble(vec -> vec.distSqr((Vec3i)spawnPosition))).toList();
    }
}

