/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitConditionSerializer;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.util.CodecUtils;
import net.silentchaos512.gear.util.TextUtil;

public record OrTraitCondition(List<ITraitCondition> children) implements ITraitCondition
{
    public static final MapCodec<OrTraitCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list(ITraitCondition.DISPATCH_CODEC).fieldOf("values").forGetter(c -> c.children)).apply((Applicative)instance, OrTraitCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, OrTraitCondition> STREAM_CODEC = StreamCodec.of((buf, con) -> CodecUtils.encodeList(buf, con.children, ITraitCondition.STREAM_CODEC), buf -> new OrTraitCondition(CodecUtils.decodeList(buf, ITraitCondition.STREAM_CODEC)));
    public static final TraitConditionSerializer<OrTraitCondition> SERIALIZER = new TraitConditionSerializer<OrTraitCondition>(CODEC, STREAM_CODEC);

    public OrTraitCondition(ITraitCondition ... values) {
        this(Arrays.asList(values));
    }

    public OrTraitCondition(List<ITraitCondition> children) {
        this.children = children;
        if (this.children.isEmpty()) {
            throw new IllegalArgumentException("Values must not be empty");
        }
        for (ITraitCondition child : this.children) {
            if (child != null) continue;
            throw new IllegalArgumentException("Value must not be null");
        }
    }

    @Override
    public TraitConditionSerializer<?> serializer() {
        return SERIALIZER;
    }

    @Override
    public boolean matches(Trait trait, PartGearKey key, List<? extends GearComponentInstance<?>> components) {
        for (ITraitCondition child : this.children) {
            if (!child.matches(trait, key, components)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent getDisplayText() {
        Component text = (Component)this.children.stream().map(ITraitCondition::getDisplayText).reduce((t1, t2) -> t1.append((Component)TextUtil.translate("trait.condition", "or")).append((Component)t2)).orElseGet(() -> Component.literal((String)""));
        return Component.literal((String)"(").append(text).append(")");
    }
}

