/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.material.MaterialSerializer;
import net.silentchaos512.gear.gear.material.CompoundMaterial;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.ProcessedMaterial;
import net.silentchaos512.gear.gear.material.SimpleMaterial;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.util.Serializer;

public final class MaterialSerializers {
    public static final Codec<Material> DISPATCH_CODEC = SgRegistries.MATERIAL_SERIALIZER.byNameCodec().dispatch(Material::getSerializer, materialSerializer -> materialSerializer.codec());
    public static final StreamCodec<RegistryFriendlyByteBuf, Material> DISPATCH_STREAM_CODEC = ByteBufCodecs.registry(SgRegistries.MATERIAL_SERIALIZER_KEY).dispatch(Material::getSerializer, Serializer::streamCodec);
    public static final DeferredRegister<MaterialSerializer<?>> REGISTRAR = DeferredRegister.create(SgRegistries.MATERIAL_SERIALIZER, (String)"silentgear");
    public static final Supplier<SimpleMaterial.Serializer> SIMPLE = MaterialSerializers.register("simple", SimpleMaterial.Serializer::new);
    public static final Supplier<CompoundMaterial.Serializer> COMPOUND = MaterialSerializers.register("compound", CompoundMaterial.Serializer::new);
    public static final Supplier<CustomCompoundMaterial.Serializer> CUSTOM_COMPOUND = MaterialSerializers.register("custom_compound", CustomCompoundMaterial.Serializer::new);
    public static final Supplier<ProcessedMaterial.Serializer> PROCESSED = MaterialSerializers.register("processed", ProcessedMaterial.Serializer::new);

    public static <T extends Material, S extends MaterialSerializer<T>> Supplier<S> register(String name, Supplier<S> serializer) {
        return REGISTRAR.register(name, serializer);
    }
}

