/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;

public record SoundPlayback(SoundEvent sound, float volume, float pitch, float pitchDeviation) {
    public static final Codec<SoundPlayback> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("sound").forGetter(s -> s.sound), (App)Codec.FLOAT.fieldOf("volume").forGetter(s -> Float.valueOf(s.volume)), (App)Codec.FLOAT.fieldOf("pitch").forGetter(s -> Float.valueOf(s.pitch)), (App)Codec.FLOAT.optionalFieldOf("pitch_deviation", (Object)Float.valueOf(0.0f)).forGetter(s -> Float.valueOf(s.pitchDeviation))).apply((Applicative)instance, SoundPlayback::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SoundPlayback> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.SOUND_EVENT), s -> s.sound, (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.volume), (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.pitch), (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.pitchDeviation), SoundPlayback::new);

    public void playAt(Level level, BlockPos pos, SoundSource source) {
        float randomPitch = this.pitch * (float)(1.0 + (double)this.pitchDeviation * SilentGear.RANDOM.nextGaussian());
        level.playSound(null, pos, this.sound, source, this.volume, randomPitch);
    }
}

