/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.press;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.silentchaos512.gear.block.ModContainerBlock;
import net.silentchaos512.gear.block.press.MetalPressBlockEntity;
import net.silentchaos512.gear.setup.SgBlockEntities;

public class MetalPressBlock
extends ModContainerBlock<MetalPressBlockEntity> {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final MapCodec<MetalPressBlock> CODEC = MetalPressBlock.simpleCodec(MetalPressBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)MetalPressBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape)MetalPressBlock.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));

    public MetalPressBlock(BlockBehaviour.Properties properties) {
        super(MetalPressBlockEntity::new, properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.interactWith(worldIn, pos, player);
        return InteractionResult.CONSUME;
    }

    protected void interactWith(Level worldIn, BlockPos pos, Player player) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof MetalPressBlockEntity) {
            MetalPressBlockEntity metalPress = (MetalPressBlockEntity)tileEntity;
            if (player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)metalPress, pos);
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof MetalPressBlockEntity) {
                MetalPressBlockEntity te = (MetalPressBlockEntity)tileEntity;
                Containers.dropContents((Level)worldIn, (BlockPos)pos, (Container)te);
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : MetalPressBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)SgBlockEntities.METAL_PRESS.get()), MetalPressBlockEntity::tick);
    }
}

