/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.util.CodecUtils;

public record HarvestTier(String name, Optional<String> levelHint, TagKey<Block> incorrectForTool) {
    public static final HarvestTier ZERO;
    public static final HarvestTier WOOD;
    public static final HarvestTier STONE;
    public static final HarvestTier GOLD;
    public static final HarvestTier IRON;
    public static final HarvestTier DIAMOND;
    public static final HarvestTier NETHERITE;
    public static final Codec<HarvestTier> CODEC;
    public static final StreamCodec<FriendlyByteBuf, HarvestTier> STREAM_CODEC;

    public boolean isBetterThan(@Nullable HarvestTier other) {
        if (other == null) {
            return true;
        }
        HolderSet.Named thisHolderSet = BuiltInRegistries.BLOCK.getOrCreateTag(this.incorrectForTool);
        HolderSet.Named otherHolderSet = BuiltInRegistries.BLOCK.getOrCreateTag(other.incorrectForTool);
        return thisHolderSet.size() < otherHolderSet.size();
    }

    public static HarvestTier create(String name, String levelHint) {
        return HarvestTier.create(name, levelHint, SilentGear.getId("incorrect_for_" + name + "_tools"));
    }

    public static HarvestTier create(String name, String levelHint, ResourceLocation incorrectForToolTagLocation) {
        return HarvestTier.create(name, levelHint, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)incorrectForToolTagLocation));
    }

    public static HarvestTier create(String name, String levelHint, TagKey<Block> incorrectForToolTag) {
        return new HarvestTier(name, Optional.of(levelHint), incorrectForToolTag);
    }

    public Component getFormattedName() {
        return (Component)this.levelHint.map(hint -> Component.translatable((String)"property.silentgear.harvest_tier.withLevelHint", (Object[])new Object[]{this.name, hint})).orElseGet(() -> Component.literal((String)this.name));
    }

    static {
        WOOD = ZERO = HarvestTier.create("wood", "0", (TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL);
        STONE = HarvestTier.create("stone", "1", (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL);
        GOLD = HarvestTier.create("gold", "1", (TagKey<Block>)BlockTags.INCORRECT_FOR_GOLD_TOOL);
        IRON = HarvestTier.create("iron", "2", (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL);
        DIAMOND = HarvestTier.create("diamond", "3", (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL);
        NETHERITE = HarvestTier.create("netherite", "4", (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL);
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ht -> ht.name), (App)Codec.STRING.optionalFieldOf("level_hint").forGetter(ht -> ht.levelHint), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("incorrect_blocks_for_tool").forGetter(ht -> ht.incorrectForTool)).apply((Applicative)instance, HarvestTier::new));
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ht -> ht.name, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), ht -> ht.levelHint, CodecUtils.tagStreamCodec(Registries.BLOCK), ht -> ht.incorrectForTool, HarvestTier::new);
    }
}

