/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data;

import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.item.modifier.ItemModifier;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.advancements.critereon.ItemAbilityPredicate;
import net.valhelsia.valhelsia_core.api.common.item.predicate.ItemAllOfPredicate;
import net.valhelsia.valhelsia_core.api.common.item.predicate.ItemAnyOfPredicate;
import net.valhelsia.valhelsia_core.api.common.item.predicate.ItemHasComponentPredicate;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryClass;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.ValhelsiaItemSubPredicates;

public class ModItemModifiers
extends DatapackRegistryClass<ItemModifier> {
    public static final DatapackRegistryHelper<ItemModifier> HELPER = (DatapackRegistryHelper)ForbiddenArcanus.REGISTRY_MANAGER.getHelper(FARegistries.ITEM_MODIFIER);
    public static final ResourceKey<ItemModifier> ETERNAL = HELPER.createKey("eternal");
    public static final ResourceKey<ItemModifier> FIERY = HELPER.createKey("fiery");
    public static final ResourceKey<ItemModifier> MAGNETIZED = HELPER.createKey("magnetized");
    public static final ResourceKey<ItemModifier> DEMOLISHING = HELPER.createKey("demolishing");
    public static final ResourceKey<ItemModifier> AQUATIC = HELPER.createKey("aquatic");
    public static final ResourceKey<ItemModifier> SOULBOUND = HELPER.createKey("soulbound");
    private HolderGetter<Enchantment> enchantmentGetter;

    public ModItemModifiers(BootstrapContext<ItemModifier> context) {
        super(context);
    }

    public void bootstrap(BootstrapContext<ItemModifier> context) {
        this.enchantmentGetter = context.lookup(Registries.ENCHANTMENT);
        ItemPredicate eternalPredicate = ItemPredicate.Builder.item().withSubPredicate((ItemSubPredicate.Type)ValhelsiaItemSubPredicates.ALL_OF.get(), (ItemSubPredicate)new ItemAllOfPredicate(Map.of((ItemSubPredicate.Type)ValhelsiaItemSubPredicates.HAS_COMPONENT.get(), List.of(new ItemHasComponentPredicate(DataComponents.MAX_DAMAGE), new ItemHasComponentPredicate(DataComponents.DAMAGE))))).build();
        ItemPredicate isToolPredicate = ItemPredicate.Builder.item().withSubPredicate((ItemSubPredicate.Type)ValhelsiaItemSubPredicates.ANY_OF.get(), (ItemSubPredicate)new ItemAnyOfPredicate(Map.of(ItemAbilityPredicate.TYPE, List.of(new ItemAbilityPredicate(ItemAbilities.PICKAXE_DIG), new ItemAbilityPredicate(ItemAbilities.AXE_DIG), new ItemAbilityPredicate(ItemAbilities.SHOVEL_DIG), new ItemAbilityPredicate(ItemAbilities.HOE_DIG))))).build();
        ItemPredicate magnetizedPredicate = ItemPredicate.Builder.item().of(ItemTags.FOOT_ARMOR).build();
        ItemPredicate aquaticPredicate = ItemPredicate.Builder.item().of(ItemTags.HEAD_ARMOR).build();
        ItemPredicate soulBoundPredicate = ItemPredicate.Builder.item().of(ModTags.Items.SOULBOUND_APPLICABLE).build();
        this.register(ETERNAL, eternalPredicate, ModTags.Items.ETERNAL_INCOMPATIBLE, ModTags.Enchantments.ETERNAL_INCOMPATIBLE, (HolderSet<DataComponentType<?>>)HolderSet.direct((Holder[])new Holder[]{BuiltInRegistries.DATA_COMPONENT_TYPE.wrapAsHolder((Object)DataComponents.DAMAGE), BuiltInRegistries.DATA_COMPONENT_TYPE.wrapAsHolder((Object)DataComponents.MAX_DAMAGE)}), ModItemModifiers.createDisplay(ETERNAL, FastColor.ARGB32.color((int)255, (int)170, (int)181, (int)159), FastColor.ARGB32.color((int)255, (int)49, (int)57, (int)56)));
        this.register(FIERY, isToolPredicate, ModTags.Items.FIERY_INCOMPATIBLE, ModTags.Enchantments.FIERY_INCOMPATIBLE, ModItemModifiers.createDisplay(FIERY, FastColor.ARGB32.color((int)255, (int)255, (int)143, (int)0), FastColor.ARGB32.color((int)255, (int)88, (int)6, (int)6)));
        this.register(MAGNETIZED, magnetizedPredicate, ModTags.Items.MAGNETIZED_INCOMPATIBLE, ModTags.Enchantments.MAGNETIZED_INCOMPATIBLE, ModItemModifiers.createDisplay(MAGNETIZED, FastColor.ARGB32.color((int)255, (int)200, (int)201, (int)215), FastColor.ARGB32.color((int)255, (int)87, (int)105, (int)99)));
        this.register(DEMOLISHING, isToolPredicate, ModTags.Items.DEMOLISHING_INCOMPATIBLE, ModTags.Enchantments.DEMOLISHING_INCOMPATIBLE, ModItemModifiers.createDisplay(DEMOLISHING, FastColor.ARGB32.color((int)255, (int)111, (int)84, (int)80), FastColor.ARGB32.color((int)255, (int)78, (int)58, (int)39)));
        this.register(AQUATIC, aquaticPredicate, ModTags.Items.AQUATIC_INCOMPATIBLE, ModTags.Enchantments.AQUATIC_INCOMPATIBLE, ModItemModifiers.createDisplay(AQUATIC, FastColor.ARGB32.color((int)255, (int)90, (int)130, (int)243), FastColor.ARGB32.color((int)255, (int)35, (int)79, (int)204)));
        this.register(SOULBOUND, soulBoundPredicate, ModTags.Items.SOULBOUND_INCOMPATIBLE, ModTags.Enchantments.SOULBOUND_INCOMPATIBLE, ModItemModifiers.createDisplay(SOULBOUND, FastColor.ARGB32.color((int)255, (int)166, (int)185, (int)246), FastColor.ARGB32.color((int)255, (int)247, (int)184, (int)217)));
    }

    private void register(ResourceKey<ItemModifier> key, ItemPredicate predicate, TagKey<Item> incompatibleItems, TagKey<Enchantment> incompatibleEnchantments, ItemModifier.DisplaySettings displaySettings) {
        this.getContext().register(key, (Object)new ItemModifier(predicate, (HolderSet<Item>)BuiltInRegistries.ITEM.getOrCreateTag(incompatibleItems), (HolderSet<Enchantment>)this.enchantmentGetter.getOrThrow(incompatibleEnchantments), HolderSet.empty(), displaySettings));
    }

    private void register(ResourceKey<ItemModifier> key, ItemPredicate predicate, TagKey<Item> incompatibleItems, TagKey<Enchantment> incompatibleEnchantments, HolderSet<DataComponentType<?>> componentsToRemove, ItemModifier.DisplaySettings displaySettings) {
        this.getContext().register(key, (Object)new ItemModifier(predicate, (HolderSet<Item>)BuiltInRegistries.ITEM.getOrCreateTag(incompatibleItems), (HolderSet<Enchantment>)this.enchantmentGetter.getOrThrow(incompatibleEnchantments), componentsToRemove, displaySettings));
    }

    private static ItemModifier.DisplaySettings createDisplay(ResourceKey<ItemModifier> key, int startColor, int endColor) {
        return new ItemModifier.DisplaySettings((Component)Component.translatable((String)Util.makeDescriptionId((String)"modifier", (ResourceLocation)key.location())), key.location().withPrefix("textures/gui/tooltip/").withSuffix(".png"), (Pair<Integer, Integer>)Pair.of((Object)startColor, (Object)endColor));
    }
}

