/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.block.SoullessSandBlock;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SoulExtractorItem
extends Item {
    private static final int USE_DURATION = 35;

    public SoulExtractorItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (player == null || player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (this.isValidBlock(level, pos, player)) {
            player.startUsingItem(context.getHand());
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(context);
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity) {
        Player player;
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).isShiftKeyDown()) {
            return stack;
        }
        BlockPos pos = SoulExtractorItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY).getBlockPos();
        if (!this.isValidBlock(level, pos, player)) {
            return stack;
        }
        RandomSource random = player.getRandom();
        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        for (int i = 0; i < 4; ++i) {
            level.addParticle((ParticleOptions)ModParticles.SOUL.get(), (double)((float)pos.getX() + random.nextFloat()), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat()), 1.0, 1.0, 1.0);
        }
        if (!level.isClientSide()) {
            level.setBlockAndUpdate(pos, ((SoullessSandBlock)((Object)ModBlocks.SOULLESS_SAND.get())).defaultBlockState());
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.SOUL.get())));
        }
        return stack;
    }

    private boolean isValidBlock(Level level, BlockPos pos, Player player) {
        return level.mayInteract(player, pos) && level.getBlockState(pos).is(Blocks.SOUL_SAND);
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingUseDuration) {
        Player player;
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).isShiftKeyDown()) {
            livingEntity.stopUsingItem();
            return;
        }
        BlockPos pos = SoulExtractorItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY).getBlockPos();
        if (this.isValidBlock(level, pos, player) && player.getRandom().nextInt(6) == 1) {
            level.levelEvent(player, 2001, pos, Block.getId((BlockState)level.getBlockState(pos)));
        }
    }

    public int getUseDuration(@Nonnull ItemStack stack, LivingEntity entity) {
        return 35;
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean canAttackBlock(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, Player player) {
        return !player.getAbilities().instabuild;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.translatable((String)"tooltip.forbidden_arcanus.soul_extractor").withStyle(ChatFormatting.GRAY));
    }
}

