/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.lostsoul;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.LostSoulAi;
import com.stal111.forbidden_arcanus.core.init.ModMemoryModules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class AbstractLostSoul
extends PathfinderMob {
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryModuleType.IS_PANICKING, (Object)((MemoryModuleType)ModMemoryModules.SCARED_TIME.get()));
    protected static final ImmutableList<SensorType<? extends Sensor<? super AbstractLostSoul>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.IS_IN_WATER);
    public static final EntityDataAccessor<Boolean> DATA_SCARED = SynchedEntityData.defineId(AbstractLostSoul.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int extractCounter = 0;
    public final AnimationState stillAnimationState = new AnimationState();
    public final AnimationState fearAnimationState = new AnimationState();
    private final Vector3f trailColor;

    public AbstractLostSoul(EntityType<? extends AbstractLostSoul> entityType, Level level, Vector3f trailColor) {
        super(entityType, level);
        this.trailColor = trailColor;
        this.setPathfindingMalus(PathType.BLOCKED, 16.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.moveControl = new FlyingMoveControl((Mob)this, 15, true);
        this.noPhysics = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    public static boolean canSpawn(EntityType<? extends AbstractLostSoul> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return true;
    }

    public void knockback(double strength, double x, double z) {
    }

    protected Brain.Provider<AbstractLostSoul> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return LostSoulAi.makeBrain((Brain<AbstractLostSoul>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<AbstractLostSoul> getBrain() {
        return super.getBrain();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos).isAir() ? 35.0f : 0.0f;
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SCARED, (Object)false);
    }

    public void tick() {
        if (!this.level().isClientSide()) {
            if (this.extractCounter != 0) {
                --this.extractCounter;
            }
            if (this.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY_ENTITY) && !this.isScared()) {
                this.entityData.set(DATA_SCARED, (Object)true);
                this.setPathfindingMalus(PathType.BLOCKED, 0.0f);
                this.getBrain().setActiveActivityIfPossible(Activity.PANIC);
            }
        } else if (this.level().getGameTime() % 10L == 0L) {
            Vec3 viewVector = this.calculateViewVector(this.getXRot(), this.getYRot());
            this.level().addParticle((ParticleOptions)new DustParticleOptions(this.trailColor, 1.0f), this.getX() - viewVector.x * 0.5, this.getY() + 0.2, this.getZ() - viewVector.z * 0.5, 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(DATA_SCARED)) {
            if (this.isScared()) {
                this.fearAnimationState.startIfStopped(this.tickCount);
                this.stillAnimationState.stop();
            } else {
                this.stillAnimationState.startIfStopped(this.tickCount);
                this.fearAnimationState.stop();
            }
        }
        super.onSyncedDataUpdated(key);
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("lostSoulBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Scared", ((Boolean)this.entityData.get(DATA_SCARED)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_SCARED, (Object)tag.getBoolean("Scared"));
    }

    public boolean isScared() {
        return (Boolean)this.entityData.get(DATA_SCARED);
    }
}

