/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.emi;

import com.klikli_dev.theurgy.content.recipe.ReformationRecipe;
import com.klikli_dev.theurgy.integration.emi.EmiPlugin;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class ReformationEmiRecipe
implements EmiRecipe {
    private final RecipeHolder<ReformationRecipe> recipe;

    public ReformationEmiRecipe(RecipeHolder<ReformationRecipe> recipe) {
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiPlugin.REFORMATION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        ((ReformationRecipe)this.recipe.value()).getSources().forEach(source -> inputs.add(EmiIngredient.of((Ingredient)source.ingredient(), (long)source.count())));
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemStack)((ReformationRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
    }

    public List<EmiIngredient> getCatalysts() {
        ArrayList<EmiIngredient> catalysts = new ArrayList<EmiIngredient>();
        catalysts.add((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get())));
        catalysts.add((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get())));
        catalysts.add((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get())));
        catalysts.add((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get())));
        catalysts.add(EmiIngredient.of((Ingredient)((ReformationRecipe)this.recipe.value()).getTarget()));
        return catalysts;
    }

    public int getDisplayWidth() {
        return 180;
    }

    public int getDisplayHeight() {
        return 100;
    }

    public void addWidgets(WidgetHolder widgets) {
        int startY;
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 130, 19);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 19, 19);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 65, 19);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get())), 1, 19).drawBack(false);
        widgets.addSlot(EmiIngredient.of((Ingredient)((ReformationRecipe)this.recipe.value()).getTarget()), 45, 19).catalyst(true).appendTooltip((Component)Component.literal((String)" ")).appendTooltip((Component)Component.translatable((String)"theurgy.jei.misc.source_sulfur.tooltip").withStyle(s -> s.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.YELLOW)));
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get())), 45, 42).drawBack(false);
        int sourceSlotX = 90;
        int sourceSlotY = startY = 55;
        for (int i = 0; i < 8; ++i) {
            if (i < ((ReformationRecipe)this.recipe.value()).getSources().size()) {
                SizedIngredient ingredient = ((ReformationRecipe)this.recipe.value()).getSources().get(i);
                widgets.addSlot(EmiIngredient.of((Ingredient)ingredient.ingredient(), (long)ingredient.count()), sourceSlotX, sourceSlotY);
            } else {
                widgets.addSlot(sourceSlotX, sourceSlotY);
            }
            sourceSlotY -= 18;
            if (i % 4 != 3) continue;
            sourceSlotY = startY;
            sourceSlotX += 18;
        }
        int flux = ((ReformationRecipe)this.recipe.value()).getMercuryFlux();
        MutableComponent mercuryFluxComponent = Component.translatable((String)"theurgy.jei.misc.mercury_flux", (Object[])new Object[]{flux});
        widgets.addText((Component)mercuryFluxComponent, 1, 90, -8355712, false);
        int count = ((ReformationRecipe)this.recipe.value()).getSources().size();
        MutableComponent sourcePedestalComponent = Component.translatable((String)"theurgy.jei.misc.source_pedestal_count", (Object[])new Object[]{count});
        widgets.addText((Component)sourcePedestalComponent, 95 - font.width((FormattedText)sourcePedestalComponent), 78, -8355712, false);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get())), 99, startY + 18).drawBack(false);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)((ReformationRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)), 160, 19).recipeContext((EmiRecipe)this);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get())), 160, 42).drawBack(false);
    }
}

