/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.worldgen;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.datagen.worldgen.ConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class PlacedFeatures {
    public static final ResourceKey<PlacedFeature> SAL_AMMONIAC_ORE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Theurgy.loc("sal_ammoniac_ore"));

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, SAL_AMMONIAC_ORE, (Holder)configuredFeatures.getOrThrow(ConfiguredFeatures.SAL_AMMONIAC_ORE), PlacedFeatures.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)200))));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier rarity, PlacementModifier height) {
        return List.of(rarity, InSquarePlacement.spread(), height, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return PlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)pCount), pHeightRange);
    }

    private static List<PlacementModifier> rareOrePlacement(int pChance, PlacementModifier pHeightRange) {
        return PlacedFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)pChance), pHeightRange);
    }
}

