/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.divinationrod.DivinationRodItem;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ShapedRecipeProvider
extends JsonRecipeProvider {
    public ShapedRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "crafting/shaped");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T1.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T1.get())).build()).pattern(" GR").pattern(" RG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN));
        DataComponentPatch.Builder amethystDivinationRodSettings = this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.AMETHYST_DIVINATION_ROD.get()));
        amethystDivinationRodSettings.set((DataComponentType)DataComponentRegistry.DIVINATION_LINKED_BLOCK.get(), (Object)Blocks.BUDDING_AMETHYST.builtInRegistryHolder());
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.AMETHYST_DIVINATION_ROD.get(), 1, amethystDivinationRodSettings.build()).pattern(" GP").pattern(" RG").pattern("R  ").define('P', (TagKey<Item>)Tags.Items.DYES_PURPLE).define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN));
        this.makeRecipe(new ShapedRecipeBuilder("theurgy:divination_rod", (ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get())).build()).pattern(" GS").pattern(" RG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_ABUNDANT));
        this.makeRecipe(new ShapedRecipeBuilder("theurgy:divination_rod", (ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get())).build()).pattern(" GS").pattern(" RG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_COMMON));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T2.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T2.get())).build()).pattern(" GM").pattern(" AG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST).define('M', (TagKey<Item>)Tags.Items.NUGGETS_GOLD));
        this.makeRecipe(new ShapedRecipeBuilder("theurgy:divination_rod", (ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get())).build()).pattern(" GS").pattern(" AG").pattern("R  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_RARE));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T3.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T3.get())).build()).pattern(" GD").pattern(" QG").pattern("A  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('Q', (TagKey<Item>)Tags.Items.GEMS_QUARTZ).define('D', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST));
        this.makeRecipe(new ShapedRecipeBuilder("theurgy:divination_rod", (ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get())).build()).pattern(" GS").pattern(" DG").pattern("A  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('D', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS_PRECIOUS));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.DIVINATION_ROD_T4.get(), 1, this.makeDivinationRodSettings((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T4.get())).build()).pattern(" GM").pattern(" RG").pattern("A  ").define('G', (TagKey<Item>)Tags.Items.GLASS_BLOCKS).define('R', (TagKey<Item>)Tags.Items.RODS_BLAZE).define('M', (TagKey<Item>)Tags.Items.ORES_NETHERITE_SCRAP).define('A', (TagKey<Item>)Tags.Items.GEMS_AMETHYST));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get(), 1).pattern("CCC").pattern("CSC").pattern("SSS").define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.CALCINATION_OVEN.get(), 1).pattern(" I ").pattern("ICI").pattern(" I ").define('C', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.DISTILLER.get(), 1).pattern(" I ").pattern("ICI").pattern("SSS").define('C', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get(), 1).pattern("CCC").pattern("CBC").pattern("SSS").define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('B', (ItemLike)Items.CAULDRON).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), 1).pattern("SSS").pattern("III").pattern("R R").define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.SAL_AMMONIAC_TANK.get(), 1).pattern("ICI").pattern("ICI").pattern("RCR").define('R', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('I', (TagKey<Item>)Tags.Items.INGOTS_IRON));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.INCUBATOR.get(), 1).pattern("PSP").pattern("GGG").pattern("SCS").define('P', (TagKey<Item>)ItemTags.PLANKS).define('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('G', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.INCUBATOR_MERCURY_VESSEL.get(), 1).pattern("cMc").pattern("c c").pattern("SSS").define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('M', ItemTagRegistry.ALCHEMICAL_MERCURIES).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.INCUBATOR_SALT_VESSEL.get(), 1).pattern("csc").pattern("c c").pattern("SSS").define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('s', ItemTagRegistry.ALCHEMICAL_SALTS).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.INCUBATOR_SULFUR_VESSEL.get(), 1).pattern("csc").pattern("c c").pattern("SSS").define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('s', ItemTagRegistry.ALCHEMICAL_SULFURS).define('S', (TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.MERCURY_CATALYST.get(), 1).pattern("imi").pattern("gQg").pattern("igi").define('Q', (ItemLike)Items.QUARTZ_BLOCK).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('i', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('m', ItemTagRegistry.ALCHEMICAL_MERCURIES));
        this.makeRecipe(this.name((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get()) + "_from_campfire", new ShapedRecipeBuilder((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get(), 1).pattern(" h ").pattern("gmg").pattern("sss").define('h', (ItemLike)Items.CAMPFIRE).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (TagKey<Item>)Tags.Items.STONES).define('m', ItemTagRegistry.ALCHEMICAL_MERCURIES));
        this.makeRecipe(this.name((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get()) + "_from_lava_bucket", new ShapedRecipeBuilder((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get(), 1).pattern(" h ").pattern("gmg").pattern("sss").define('h', (ItemLike)Items.LAVA_BUCKET).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (TagKey<Item>)Tags.Items.STONES).define('m', ItemTagRegistry.ALCHEMICAL_MERCURIES));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get(), 1).pattern(" a ").pattern("gSg").pattern("sss").define('a', ItemTagRegistry.GEMS_SAL_AMMONIAC).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (TagKey<Item>)Tags.Items.STONES).define('S', ItemTagRegistry.ALCHEMICAL_SULFURS));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get(), 1).pattern("cSc").pattern("cdc").pattern("sss").define('S', ItemTagRegistry.ALCHEMICAL_SULFURS).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER).define('s', (ItemLike)Items.BLACKSTONE).define('d', (TagKey<Item>)Tags.Items.GEMS_DIAMOND));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get(), 1).pattern("sSs").pattern("iii").pattern("sss").define('S', ItemTagRegistry.ALCHEMICAL_SULFURS).define('i', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('s', (ItemLike)Items.BLACKSTONE));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get(), 1).pattern("ggg").pattern("gSg").pattern("sss").define('S', ItemTagRegistry.ALCHEMICAL_SULFURS).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('s', (ItemLike)Items.BLACKSTONE));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.FERMENTATION_VAT.get(), 1).pattern("csc").pattern("cbc").pattern("cCc").define('s', ItemTagRegistry.ALCHEMICAL_SULFURS).define('b', (TagKey<Item>)Tags.Items.BARRELS_WOODEN).define('C', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.DIGESTION_VAT.get(), 1).pattern(" s ").pattern("gpg").pattern("SSS").define('s', ItemTagRegistry.GEMS_SAL_AMMONIAC).define('p', (ItemLike)Items.DECORATED_POT).define('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD).define('S', (TagKey<Item>)Tags.Items.SANDSTONE_BLOCKS));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.COPPER_WIRE.get(), 10).pattern("cmc").define('m', (ItemLike)ItemRegistry.MERCURY_SHARD).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.MERCURIAL_WAND.get(), 1).pattern(" sm").pattern(" cs").pattern("s  ").define('m', (ItemLike)ItemRegistry.MERCURY_SHARD).define('s', (TagKey<Item>)Tags.Items.RODS_WOODEN).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.LOGISTICS_ITEM_INSERTER.get(), 1).pattern("m").pattern("c").define('m', (ItemLike)ItemRegistry.MERCURY_SHARD).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.LOGISTICS_ITEM_EXTRACTOR.get(), 1).pattern("c").pattern("m").define('m', (ItemLike)ItemRegistry.MERCURY_SHARD).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.LOGISTICS_FLUID_INSERTER.get(), 1).pattern("d").pattern("m").pattern("c").define('d', (TagKey<Item>)Tags.Items.DYES_BLUE).define('m', (ItemLike)ItemRegistry.MERCURY_SHARD).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.LOGISTICS_FLUID_EXTRACTOR.get(), 1).pattern("d").pattern("c").pattern("m").define('d', (TagKey<Item>)Tags.Items.DYES_BLUE).define('m', (ItemLike)ItemRegistry.MERCURY_SHARD).define('c', (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.LOGISTICS_CONNECTION_NODE.get(), 3).pattern(" m ").pattern(" i ").pattern("bbb").define('m', (ItemLike)ItemRegistry.MERCURY_SHARD).define('i', (TagKey<Item>)Tags.Items.INGOTS_IRON).define('b', (TagKey<Item>)Tags.Items.BRICKS_NORMAL));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.LIST_FILTER.get(), 9).pattern("ppp").pattern("pmp").pattern("ppp").define('p', (ItemLike)Items.PAPER).define('m', (ItemLike)ItemRegistry.MERCURY_SHARD));
        this.makeRecipe(new ShapedRecipeBuilder((ItemLike)ItemRegistry.ATTRIBUTE_FILTER.get(), 9).pattern("pfp").pattern("pmp").pattern("ppp").define('f', (ItemLike)Items.FEATHER).define('p', (ItemLike)Items.PAPER).define('m', (ItemLike)ItemRegistry.MERCURY_SHARD));
    }

    public DataComponentPatch.Builder makeDivinationRodSettings(DivinationRodItem rodItem) {
        return this.makeDivinationRodSettings(rodItem.defaultTier, rodItem.defaultAllowedBlocksTag, rodItem.defaultDisallowedBlocksTag, rodItem.defaultRange, rodItem.defaultDuration, rodItem.defaultDurability);
    }

    public DataComponentPatch.Builder makeDivinationRodSettings(Tiers defaultTier, TagKey<Block> defaultAllowedBlocksTag, TagKey<Block> defaultDisallowedBlocksTag, int defaultRange, int defaultDuration, int defaultDurability) {
        return DataComponentPatch.builder().set((DataComponentType)DataComponentRegistry.DIVINATION_SETTINGS_TIER.get(), (Object)defaultTier).set((DataComponentType)DataComponentRegistry.DIVINATION_SETTINGS_ALLOWED_BLOCKS_TAG.get(), defaultAllowedBlocksTag).set((DataComponentType)DataComponentRegistry.DIVINATION_SETTINGS_DISALLOWED_BLOCKS_TAG.get(), defaultDisallowedBlocksTag).set((DataComponentType)DataComponentRegistry.DIVINATION_SETTINGS_RANGE.get(), (Object)defaultRange).set((DataComponentType)DataComponentRegistry.DIVINATION_SETTINGS_DURATION.get(), (Object)defaultDuration).set((DataComponentType)DataComponentRegistry.DIVINATION_SETTINGS_MAX_DAMAGE.get(), (Object)defaultDurability);
    }

    protected void makeRecipe(ShapedRecipeBuilder recipe) {
        this.makeRecipe(this.name(recipe.result()), recipe);
    }

    protected void makeRecipe(ItemLike result, ShapedRecipeBuilder recipe) {
        this.makeRecipe(this.name(result), recipe);
    }

    protected void makeRecipe(String name, ShapedRecipeBuilder recipe) {
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    @NotNull
    public String getName() {
        return "Shaped Crafting Recipes";
    }

    protected static class ShapedRecipeBuilder {
        private final JsonObject recipe;
        private final ItemStack result;

        public ShapedRecipeBuilder(ItemLike result) {
            this((Holder<Item>)result.asItem().builtInRegistryHolder());
        }

        public ShapedRecipeBuilder(ItemLike result, int count) {
            this((Holder<Item>)result.asItem().builtInRegistryHolder(), count);
        }

        public ShapedRecipeBuilder(ItemLike result, int count, DataComponentPatch patch) {
            this((Holder<Item>)result.asItem().builtInRegistryHolder(), count, patch);
        }

        public ShapedRecipeBuilder(String recipeType, ItemLike result, int count, DataComponentPatch patch) {
            this(recipeType, new ItemStack((Holder)result.asItem().builtInRegistryHolder(), count, patch));
        }

        public ShapedRecipeBuilder(Holder<Item> result) {
            this(result, 1);
        }

        public ShapedRecipeBuilder(Holder<Item> result, int count) {
            this(result, count, DataComponentPatch.EMPTY);
        }

        public ShapedRecipeBuilder(Holder<Item> result, int count, DataComponentPatch patch) {
            this(BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)RecipeSerializer.SHAPED_RECIPE).toString(), result, count, patch);
        }

        public ShapedRecipeBuilder(String recipeType, Holder<Item> result, int count, DataComponentPatch patch) {
            this(recipeType, new ItemStack(result, count, patch));
        }

        public ShapedRecipeBuilder(String recipeType, ItemStack result) {
            this.result = result;
            this.recipe = new JsonObject();
            this.recipe.addProperty("type", recipeType);
            this.recipe.add("result", (JsonElement)ItemStack.STRICT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)result).getOrThrow());
            this.recipe.add("key", (JsonElement)new JsonObject());
            this.recipe.add("pattern", (JsonElement)new JsonArray());
        }

        private JsonObject ingredient(TagKey<Item> tag) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", tag.location().toString());
            return jsonobject;
        }

        public ShapedRecipeBuilder define(char key, TagKey<Item> tag) {
            return this.define(key, this.ingredient(tag));
        }

        private JsonObject ingredient(ItemLike item) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ((ResourceKey)item.asItem().builtInRegistryHolder().unwrapKey().get()).location().toString());
            return jsonobject;
        }

        public ShapedRecipeBuilder define(char key, ItemLike item) {
            return this.define(key, this.ingredient(item));
        }

        public ShapedRecipeBuilder define(char key, JsonObject ingredient) {
            String keyString = String.valueOf(key);
            JsonObject keys = this.recipe.getAsJsonObject("key");
            if (keys.has(keyString)) {
                throw new IllegalArgumentException("Key " + keyString + " already defined");
            }
            keys.add(keyString, (JsonElement)ingredient);
            return this;
        }

        public ShapedRecipeBuilder pattern(String pattern) {
            this.recipe.getAsJsonArray("pattern").add(pattern);
            return this;
        }

        public JsonObject build() {
            if (!this.recipe.has("category")) {
                this.recipe.addProperty("category", CraftingBookCategory.MISC.getSerializedName());
            }
            return this.recipe;
        }

        public ItemStack result() {
            return this.result;
        }
    }
}

