/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class CalcinationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public CalcinationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "calcination");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe("_from_stone", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe("_from_sandstone", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)Tags.Items.SANDSTONE_BLOCKS));
        this.makeRecipe("_from_cobblestone", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)Tags.Items.COBBLESTONES));
        this.makeRecipe("_from_dirt", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)ItemTags.DIRT));
        this.makeRecipe("_from_sand", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)ItemTags.SAND));
        this.makeRecipe("_from_gravel", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.GRAVEL));
        this.makeRecipe("_from_clay", new Builder((ItemLike)SaltRegistry.STRATA, 4).sizedIngredient((ItemLike)Items.CLAY));
        this.makeRecipe("_from_clay_ball", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.CLAY_BALL));
        this.makeRecipe("_from_netherrack", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)Tags.Items.NETHERRACKS));
        this.makeRecipe("_from_soul_sand", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.SOUL_SAND));
        this.makeRecipe("_from_soul_soil", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.SOUL_SOIL));
        this.makeRecipe("_from_blackstone", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.BLACKSTONE));
        this.makeRecipe("_from_terracotta", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.TERRACOTTA));
        this.makeRecipe("_from_concrete", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((TagKey<Item>)Tags.Items.CONCRETES));
        this.makeRecipe("_from_crimson_nylium", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.CRIMSON_NYLIUM));
        this.makeRecipe("_from_warped_nylium", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.WARPED_NYLIUM));
        this.makeRecipe("_from_end_stone", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.END_STONE));
        this.makeRecipe("_from_purpur_block", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.PURPUR_BLOCK));
        this.makeRecipe("_from_mycelium", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.MYCELIUM));
        this.makeRecipe("_from_obsidian", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.OBSIDIAN));
        this.makeRecipe("_from_crying_obsidian", new Builder((ItemLike)SaltRegistry.STRATA, 3).sizedIngredient((ItemLike)Items.CRYING_OBSIDIAN));
        this.makeRecipe("_from_snowball", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.SNOWBALL));
        this.makeRecipe("_from_ice", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.ICE));
        this.makeRecipe("_from_packed_ice", new Builder((ItemLike)SaltRegistry.STRATA, 9).sizedIngredient((ItemLike)Items.PACKED_ICE));
        this.makeRecipe("_from_blue_ice", new Builder((ItemLike)SaltRegistry.STRATA, 64).sizedIngredient((ItemLike)Items.BLUE_ICE));
        this.makeRecipe("_from_magma_block", new Builder((ItemLike)SaltRegistry.STRATA, 2).sizedIngredient((ItemLike)Items.MAGMA_BLOCK));
        this.makeRecipe("_from_crystallized_water", new Builder((ItemLike)SaltRegistry.STRATA, 4).sizedIngredient((ItemLike)ItemRegistry.CRYSTALLIZED_WATER));
        this.makeRecipe("_from_crystallized_lava", new Builder((ItemLike)SaltRegistry.STRATA, 8).sizedIngredient((ItemLike)ItemRegistry.CRYSTALLIZED_LAVA));
        this.makeRecipe("_from_ores", new Builder((ItemLike)SaltRegistry.MINERAL, 3).sizedIngredient((TagKey<Item>)Tags.Items.ORES));
        this.makeRecipe("_from_raw_materials", new Builder((ItemLike)SaltRegistry.MINERAL).sizedIngredient((TagKey<Item>)Tags.Items.RAW_MATERIALS));
        this.makeRecipe("_from_ingots", new Builder((ItemLike)SaltRegistry.MINERAL, 2).sizedIngredient((TagKey<Item>)Tags.Items.INGOTS));
        this.makeRecipe("_from_gems", new Builder((ItemLike)SaltRegistry.MINERAL, 2).sizedIngredient((TagKey<Item>)Tags.Items.GEMS));
        this.makeRecipe("_from_other_minerals", new Builder((ItemLike)SaltRegistry.MINERAL, 2).sizedIngredient(ItemTagRegistry.OTHER_MINERALS));
        this.makeRecipe("_from_strata_salt", (Builder)new Builder((ItemLike)SaltRegistry.MINERAL).sizedIngredient((ItemLike)SaltRegistry.STRATA.get(), 5));
        this.makeRecipe("_from_crops", new Builder((ItemLike)SaltRegistry.PLANT).sizedIngredient((TagKey<Item>)Tags.Items.CROPS));
        this.makeRecipe("_from_logs", new Builder((ItemLike)SaltRegistry.PLANT).sizedIngredient((TagKey<Item>)ItemTags.LOGS));
        this.makeRecipe("_from_leaves", new Builder((ItemLike)SaltRegistry.PLANT).sizedIngredient((TagKey<Item>)ItemTags.LEAVES));
        this.makeRecipe("_from_saplings", new Builder((ItemLike)SaltRegistry.PLANT).sizedIngredient((TagKey<Item>)ItemTags.SAPLINGS));
        this.makeRecipe("_from_plant_salt", (Builder)new Builder((ItemLike)SaltRegistry.CREATURE).sizedIngredient((ItemLike)SaltRegistry.PLANT.get(), 2));
    }

    protected void makeRecipe(String suffix, Builder recipe) {
        this.recipeConsumer.accept(this.modLoc(this.name(recipe.result()) + suffix), recipe.build());
    }

    public String getName() {
        return "Calcination Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        private final ItemStack result;

        protected Builder(ItemLike result) {
            this(result, 1);
        }

        protected Builder(ItemLike result, int count) {
            this(new ItemStack(result, count));
        }

        protected Builder(ItemStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.CALCINATION);
            this.result(result);
            this.time(100);
            this.result = result;
        }

        public ItemStack result() {
            return this.result;
        }

        public Builder sizedIngredient(TagKey<Item> tag) {
            return (Builder)super.sizedIngredient(tag, 1);
        }

        public Builder sizedIngredient(ItemLike item) {
            return (Builder)super.sizedIngredient(item, 1);
        }
    }
}

