/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.salt;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AlchemicalSaltItem
extends Item {
    public AlchemicalSaltItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static List<MutableComponent> getTooltipData(ItemStack saltItem) {
        Item item = saltItem.getItem();
        if (item instanceof AlchemicalSaltItem) {
            AlchemicalSaltItem salt = (AlchemicalSaltItem)item;
            return ImmutableList.of((Object)salt.getSourceName(saltItem));
        }
        return ImmutableList.of();
    }

    public static MutableComponent formatSourceName(MutableComponent sourceName) {
        return sourceName.withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withItalic(Boolean.valueOf(true)));
    }

    public MutableComponent getSourceName(ItemStack pStack) {
        return AlchemicalSaltItem.formatSourceName(Component.translatable((String)(pStack.getDescriptionId() + ".source")));
    }

    public Component getName(ItemStack pStack) {
        return Component.translatable((String)this.getDescriptionId(pStack), (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)this.getSourceName(pStack))});
    }
}

