/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class FilterItem
extends Item
implements MenuProvider {
    public FilterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        if (pContext.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        return this.use(pContext.getLevel(), pContext.getPlayer(), pContext.getHand()).getResult();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldItem = pPlayer.getItemInHand(pUsedHand);
        if (!pPlayer.isShiftKeyDown() && pUsedHand == InteractionHand.MAIN_HAND) {
            if (!pLevel.isClientSide && pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                serverPlayer.openMenu((MenuProvider)this, buf -> ItemStack.STREAM_CODEC.encode(buf, (Object)heldItem));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        if (!Screen.hasShiftDown()) {
            List<Component> makeSummary = this.makeSummary(pStack, pContext.registries());
            if (makeSummary.isEmpty()) {
                return;
            }
            pTooltipComponents.add((Component)Component.literal((String)" "));
            pTooltipComponents.addAll(makeSummary);
        }
    }

    protected abstract List<Component> makeSummary(ItemStack var1, HolderLookup.Provider var2);

    @NotNull
    public Component getDisplayName() {
        return this.getDescription();
    }
}

