/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.worldgen;

import io.redspace.ironsspellbooks.entity.mobs.ice_spider.IceSpiderEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class IceSpiderPatrolSpawner
implements CustomSpawner {
    private static final int DELAY_FIXED = 4800;
    private static final int DELAY_VARIABLE = 1200;
    private int tickDelay;

    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!spawnEnemies) {
            return 0;
        }
        int playercount = level.players().size();
        if (playercount < 1) {
            return 0;
        }
        RandomSource randomsource = level.random;
        --this.tickDelay;
        if (this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = (4800 + randomsource.nextInt(1200)) / playercount;
        if (!level.isRaining() || randomsource.nextInt(3) != 0) {
            return 0;
        }
        Player player = null;
        for (int i = 0; i < playercount && ((player = (Player)level.players().get(randomsource.nextInt(playercount))).isSpectator() || player.isCreative()); ++i) {
            player = null;
        }
        if (player == null) {
            return 0;
        }
        int k = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
        int l = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = player.blockPosition().mutable().move(k, 0, l);
        if (!level.hasChunksAt(blockpos$mutableblockpos.getX() - 10, blockpos$mutableblockpos.getZ() - 10, blockpos$mutableblockpos.getX() + 10, blockpos$mutableblockpos.getZ() + 10)) {
            return 0;
        }
        Holder holder = level.getBiome((BlockPos)blockpos$mutableblockpos);
        if (!holder.is(ModTags.ICE_SPIDER_PATROLS)) {
            return 0;
        }
        blockpos$mutableblockpos.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).getY());
        IceSpiderEntity iceSpider = new IceSpiderEntity((Level)level);
        iceSpider.moveTo(blockpos$mutableblockpos.immutable(), 0.0f, 0.0f);
        iceSpider.setTarget((LivingEntity)player);
        level.playSound(null, iceSpider.blockPosition(), (SoundEvent)SoundRegistry.ICE_SPIDER_HOWL.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
        iceSpider.setEmergeFromGround();
        level.addFreshEntity((Entity)iceSpider);
        return 1;
    }
}

