/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GazeLesserSacredRiteType
extends TotemicRiteType {
    public GazeLesserSacredRiteType() {
        super("gaze_lesser_sacred_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, ZombieVillager.class, zv -> zv.isAlive() && !zv.isConverting()).forEach(zv -> {
                    int conversionTime = level.getRandom().nextInt(2401) + 3600;
                    CompoundTag tag = new CompoundTag();
                    tag.putInt("ConversionTime", conversionTime);
                    zv.readAdditionalSaveData(tag);
                });
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, Villager.class, villager -> villager.isAlive()).forEach(villager -> {
                    Vec3 pos = villager.position();
                    ZombieVillager zombie = (ZombieVillager)EntityType.ZOMBIE_VILLAGER.create((Level)level);
                    if (zombie != null) {
                        zombie.moveTo(pos.x, pos.y, pos.z, villager.getYRot(), villager.getXRot());
                        zombie.setVillagerData(villager.getVillagerData());
                        villager.discard();
                        level.addFreshEntity((Entity)zombie);
                    }
                });
            }
        };
    }
}

