/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GazeLesserEarthenRiteType
extends TotemicRiteType {
    public GazeLesserEarthenRiteType() {
        super("gaze_lesser_earthen_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                BlockPos pos = totemBase.getBlockPos();
                this.getNearbyBlocks(totemBase, BonemealableBlock.class).forEach(p -> {
                    CropBlock crop;
                    BlockState state;
                    Block block;
                    if (level.random.nextFloat() <= 0.06f && (block = (state = level.getBlockState(p)).getBlock()) instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state)) {
                        level.destroyBlock(p, true);
                    }
                });
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (totemBase.activeRite == null) {
                    return;
                }
                Vec3 center = Vec3.atCenterOf((Vec3i)this.getRiteEffectCenter(totemBase));
                int radius = totemBase.radiusVisibility;
                this.getNearbyEntities(totemBase, Player.class, p -> !p.isCreative() && !p.isSpectator() && !p.getAbilities().invulnerable).forEach(player -> player.addEffect(new MobEffectInstance(MobEffects.LUCK, 600, 0)));
            }
        };
    }
}

