/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;

public class GazeGreaterWickedRiteType
extends TotemicRiteType {
    public GazeGreaterWickedRiteType() {
        super("gaze_greater_wicked_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> e instanceof Monster).forEach(mob -> {
                    if (mob.getHealth() < mob.getMaxHealth()) {
                        mob.heal(2.0f);
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)mob).color(new MalumSpiritType[]{MalumSpiritTypes.WICKED_SPIRIT}).spawn(level);
                    }
                });
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, Player.class, p -> !p.isCreative() && !p.isSpectator()).forEach(player -> {
                    player.hurt(level.damageSources().magic(), 4.0f);
                    player.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 1));
                    MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)player).color(new MalumSpiritType[]{MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT}).spawn(level);
                });
            }
        };
    }
}

