/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.item.MalumItems;
import com.strawberry.gaze.GazeMod;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GazeGreaterSacredRiteType
extends TotemicRiteType {
    public GazeGreaterSacredRiteType() {
        super("gaze_greater_sacred_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (totemBase.activeRite == null) {
                    return;
                }
                double x = (double)totemBase.getBlockPos().getX() + 0.5;
                double y = (double)totemBase.getBlockPos().getY() + 0.5;
                double z = (double)totemBase.getBlockPos().getZ() + 0.5;
                List items = this.getNearbyEntities(totemBase, ItemEntity.class).toList();
                int melonCount = 0;
                int carrotCount = 0;
                int malignantLeadCount = 0;
                for (ItemEntity itemEntity : items) {
                    ItemStack stack = itemEntity.getItem();
                    if (stack.getItem() == Items.MELON_SLICE) {
                        melonCount += stack.getCount();
                        continue;
                    }
                    if (stack.getItem() == Items.CARROT) {
                        carrotCount += stack.getCount();
                        continue;
                    }
                    if (!stack.getItem().equals(MalumItems.MALIGNANT_LEAD.get())) continue;
                    malignantLeadCount += stack.getCount();
                }
                if (melonCount >= 8 || carrotCount >= 8) {
                    Item targetItem = melonCount >= 8 ? Items.MELON_SLICE : Items.CARROT;
                    Item resultItem = melonCount >= 8 ? Items.GLISTERING_MELON_SLICE : Items.GOLDEN_CARROT;
                    int toConsume = 8;
                    for (ItemEntity itemEntity : items) {
                        ItemStack stack = itemEntity.getItem();
                        if (stack.getItem() != targetItem || toConsume <= 0) continue;
                        int consumeAmount = Math.min(toConsume, stack.getCount());
                        stack.shrink(consumeAmount);
                        toConsume -= consumeAmount;
                        if (!stack.isEmpty()) continue;
                        itemEntity.discard();
                    }
                    level.addFreshEntity((Entity)new ItemEntity((Level)level, x, y + 1.0, z, new ItemStack((ItemLike)resultItem)));
                }
                if (malignantLeadCount > 0) {
                    int toConvert = malignantLeadCount;
                    for (ItemEntity itemEntity : items) {
                        ItemStack stack = itemEntity.getItem();
                        if (!stack.getItem().equals(MalumItems.MALIGNANT_LEAD.get()) || toConvert <= 0) continue;
                        int convertAmount = Math.min(toConvert, stack.getCount());
                        stack.shrink(convertAmount);
                        toConvert -= convertAmount;
                        if (stack.isEmpty()) {
                            itemEntity.discard();
                        }
                        level.addFreshEntity((Entity)new ItemEntity((Level)level, x, y + 1.0, z, new ItemStack((ItemLike)MalumItems.CTHONIC_GOLD.get(), convertAmount)));
                    }
                }
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (totemBase.activeRite == null) {
                    return;
                }
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> e instanceof Player).forEach(e -> e.addEffect(new MobEffectInstance(GazeMod.JOYFUL, 100, 0, true, true, true)));
                BlockPos center = totemBase.getBlockPos();
                int horizontalRadius = this.getRiteEffectHorizontalRadius();
                int verticalRadius = this.getRiteEffectVerticalRadius();
                BlockPos.betweenClosedStream((BlockPos)center.offset(-horizontalRadius, -verticalRadius, -horizontalRadius), (BlockPos)center.offset(horizontalRadius, verticalRadius, horizontalRadius)).forEach(pos -> {
                    Integer bites;
                    BlockState state = level.getBlockState(pos);
                    if (state.is(Blocks.CAKE) && level.random.nextFloat() <= 0.2f && (bites = (Integer)state.getValue((Property)CakeBlock.BITES)) > 0) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)CakeBlock.BITES, (Comparable)Integer.valueOf(bites - 1)), 3);
                    }
                });
            }
        };
    }
}

